/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispGeoCoordinateLcafAddress
extends LispLcafAddress {
    private final boolean north;
    private final short latitudeDegree;
    private final byte latitudeMinute;
    private final byte latitudeSecond;
    private final boolean east;
    private final short longitudeDegree;
    private final byte longitudeMinute;
    private final byte longitudeSecond;
    private final int altitude;
    private final LispAfiAddress address;

    private LispGeoCoordinateLcafAddress(boolean north, short latitudeDegree, byte latitudeMinute, byte latitudeSecond, boolean east, short longitudeDegree, byte longitudeMinute, byte longitudeSecond, int altitude, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.GEO_COORDINATE);
        this.north = north;
        this.latitudeDegree = latitudeDegree;
        this.latitudeMinute = latitudeMinute;
        this.latitudeSecond = latitudeSecond;
        this.east = east;
        this.longitudeDegree = longitudeDegree;
        this.longitudeMinute = longitudeMinute;
        this.longitudeSecond = longitudeSecond;
        this.altitude = altitude;
        this.address = address;
    }

    public boolean isNorth() {
        return this.north;
    }

    public short getLatitudeDegree() {
        return this.latitudeDegree;
    }

    public byte getLatitudeMinute() {
        return this.latitudeMinute;
    }

    public byte getLatitudeSecond() {
        return this.latitudeSecond;
    }

    public boolean isEast() {
        return this.east;
    }

    public short getLongitudeDegree() {
        return this.longitudeDegree;
    }

    public byte getLongitudeMinute() {
        return this.longitudeMinute;
    }

    public byte getLongitudeSecond() {
        return this.longitudeSecond;
    }

    public int getAltitude() {
        return this.altitude;
    }

    public LispAfiAddress getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.north, this.latitudeDegree, this.latitudeMinute, this.latitudeSecond, this.east, this.longitudeDegree, this.longitudeMinute, this.longitudeSecond, this.altitude, this.address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispGeoCoordinateLcafAddress) {
            LispGeoCoordinateLcafAddress other = (LispGeoCoordinateLcafAddress)obj;
            return Objects.equals(this.north, other.north) && Objects.equals(this.latitudeDegree, other.latitudeDegree) && Objects.equals(this.latitudeMinute, other.latitudeMinute) && Objects.equals(this.latitudeSecond, other.latitudeSecond) && Objects.equals(this.east, other.east) && Objects.equals(this.longitudeDegree, other.longitudeDegree) && Objects.equals(this.longitudeMinute, other.longitudeMinute) && Objects.equals(this.longitudeSecond, other.longitudeSecond) && Objects.equals(this.altitude, other.altitude) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("north", this.north).add("latitude degree", (int)this.latitudeDegree).add("latitude minute", (int)this.latitudeMinute).add("latitude second", (int)this.latitudeSecond).add("east", this.east).add("longitude degree", (int)this.longitudeDegree).add("longitude minute", (int)this.longitudeMinute).add("longitude second", (int)this.longitudeSecond).add("altitude", this.altitude).add("address", (Object)this.address).toString();
    }

    public static class GeoCoordinateLcafAddressWriter
    implements LispAddressWriter<LispGeoCoordinateLcafAddress> {
        private static final int NORTH_SHIFT_BIT = 15;
        private static final int EAST_SHIFT_BIT = 15;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispGeoCoordinateLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            int north = 0;
            if (address.isNorth()) {
                north = Short.MIN_VALUE;
            }
            byteBuf.writeShort(north + address.latitudeDegree);
            byteBuf.writeByte((int)address.latitudeMinute);
            byteBuf.writeByte((int)address.latitudeSecond);
            int east = 0;
            if (address.isEast()) {
                east = Short.MIN_VALUE;
            }
            byteBuf.writeShort(east + address.longitudeDegree);
            byteBuf.writeByte((int)address.longitudeMinute);
            byteBuf.writeByte((int)address.longitudeSecond);
            byteBuf.writeInt(address.altitude);
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, address.getAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class GeoCoordinateLcafAddressReader
    implements LispAddressReader<LispGeoCoordinateLcafAddress> {
        private static final int NORTH_INDEX = 7;
        private static final int EAST_INDEX = 7;
        private static final int FLAG_SHIFT = 8;

        @Override
        public LispGeoCoordinateLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            byte flagWithLatitude = byteBuf.readByte();
            boolean north = ByteOperator.getBit((byte)flagWithLatitude, (int)7);
            short latitudeFirst = flagWithLatitude;
            if (north) {
                latitudeFirst = (short)(flagWithLatitude & 0x7F);
            }
            short latitude = (short)((latitudeFirst << 8) + byteBuf.readByte());
            byte latitudeMinute = byteBuf.readByte();
            byte latitudeSecond = byteBuf.readByte();
            byte flagWithLongitude = byteBuf.readByte();
            boolean east = ByteOperator.getBit((byte)flagWithLongitude, (int)7);
            short longitudeFirst = flagWithLongitude;
            if (east) {
                longitudeFirst = (short)(flagWithLongitude & 0x7F);
            }
            short longitude = (short)((longitudeFirst << 8) + byteBuf.readByte());
            byte longitudeMinute = byteBuf.readByte();
            byte longitudeSecond = byteBuf.readByte();
            int altitude = byteBuf.readInt();
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new GeoCoordinateAddressBuilder().withIsNorth(north).withLatitudeDegree(latitude).withLatitudeMinute(latitudeMinute).withLatitudeSecond(latitudeSecond).withIsEast(east).withLongitudeDegree(longitude).withLongitudeMinute(longitudeMinute).withLongitudeSecond(longitudeSecond).withAltitude(altitude).withAddress(address).build();
        }
    }

    public static final class GeoCoordinateAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<GeoCoordinateAddressBuilder> {
        private boolean north;
        private short latitudeDegree;
        private byte latitudeMinute;
        private byte latitudeSecond;
        private boolean east;
        private short longitudeDegree;
        private byte longitudeMinute;
        private byte longitudeSecond;
        private int altitude;
        private LispAfiAddress address;

        public GeoCoordinateAddressBuilder withIsNorth(boolean north) {
            this.north = north;
            return this;
        }

        public GeoCoordinateAddressBuilder withLatitudeDegree(short latitudeDegree) {
            this.latitudeDegree = latitudeDegree;
            return this;
        }

        public GeoCoordinateAddressBuilder withLatitudeMinute(byte latitudeMinute) {
            this.latitudeMinute = latitudeMinute;
            return this;
        }

        public GeoCoordinateAddressBuilder withLatitudeSecond(byte latitudeSecond) {
            this.latitudeSecond = latitudeSecond;
            return this;
        }

        public GeoCoordinateAddressBuilder withIsEast(boolean east) {
            this.east = east;
            return this;
        }

        public GeoCoordinateAddressBuilder withLongitudeDegree(short longitudeDegree) {
            this.longitudeDegree = longitudeDegree;
            return this;
        }

        public GeoCoordinateAddressBuilder withLongitudeMinute(byte longitudeMinute) {
            this.longitudeMinute = longitudeMinute;
            return this;
        }

        public GeoCoordinateAddressBuilder withLongitudeSecond(byte longitudeSecond) {
            this.longitudeSecond = longitudeSecond;
            return this;
        }

        public GeoCoordinateAddressBuilder withAltitude(int altitude) {
            this.altitude = altitude;
            return this;
        }

        public GeoCoordinateAddressBuilder withAddress(LispAfiAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public LispGeoCoordinateLcafAddress build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Must specify an AFI address");
            return new LispGeoCoordinateLcafAddress(this.north, this.latitudeDegree, this.latitudeMinute, this.latitudeSecond, this.east, this.longitudeDegree, this.longitudeMinute, this.longitudeSecond, this.altitude, this.address);
        }
    }
}

