/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispAsLcafAddress
extends LispLcafAddress {
    private final LispAfiAddress address;
    private final int asNumber;

    private LispAsLcafAddress(int asNumber, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.AS);
        this.asNumber = asNumber;
        this.address = address;
    }

    public LispAfiAddress getAddress() {
        return this.address;
    }

    public int getAsNumber() {
        return this.asNumber;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.asNumber, this.address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispAsLcafAddress) {
            LispAsLcafAddress other = (LispAsLcafAddress)obj;
            return Objects.equals(this.asNumber, other.asNumber) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("asNumber", this.asNumber).add("address", (Object)this.address).toString();
    }

    public static class AsLcafAddressWriter
    implements LispAddressWriter<LispAsLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispAsLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeInt(address.getAsNumber());
            new LispAfiAddress.AfiAddressWriter().writeTo(byteBuf, address.getAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class AsLcafAddressReader
    implements LispAddressReader<LispAsLcafAddress> {
        @Override
        public LispAsLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            int asNumber = (int)byteBuf.readUnsignedInt();
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new AsAddressBuilder().withAsNumber(asNumber).withAddress(address).build();
        }
    }

    public static final class AsAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<AsAddressBuilder> {
        private int asNumber;
        private LispAfiAddress address;

        public AsAddressBuilder withAsNumber(int asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        public AsAddressBuilder withAddress(LispAfiAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public LispAsLcafAddress build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Must specify an address");
            return new LispAsLcafAddress(this.asNumber, this.address);
        }
    }
}

