/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispAppDataLcafAddress
extends LispLcafAddress {
    private final byte protocol;
    private final int ipTos;
    private final short localPortLow;
    private final short localPortHigh;
    private final short remotePortLow;
    private final short remotePortHigh;
    private LispAfiAddress address;

    private LispAppDataLcafAddress(byte protocol, int ipTos, short localPortLow, short localPortHigh, short remotePortLow, short remotePortHigh, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.APPLICATION_DATA);
        this.protocol = protocol;
        this.ipTos = ipTos;
        this.localPortLow = localPortLow;
        this.localPortHigh = localPortHigh;
        this.remotePortLow = remotePortLow;
        this.remotePortHigh = remotePortHigh;
        this.address = address;
    }

    private LispAppDataLcafAddress(byte reserved1, byte reserved2, byte flag, short length, byte protocol, int ipTos, short localPortLow, short localPortHigh, short remotePortLow, short remotePortHigh, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.APPLICATION_DATA, reserved1, reserved2, flag, length);
        this.protocol = protocol;
        this.ipTos = ipTos;
        this.localPortLow = localPortLow;
        this.localPortHigh = localPortHigh;
        this.remotePortLow = remotePortLow;
        this.remotePortHigh = remotePortHigh;
        this.address = address;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public int getIpTos() {
        return this.ipTos;
    }

    public short getLocalPortLow() {
        return this.localPortLow;
    }

    public short getLocalPortHigh() {
        return this.localPortHigh;
    }

    public short getRemotePortLow() {
        return this.remotePortLow;
    }

    public short getRemotePortHigh() {
        return this.remotePortHigh;
    }

    public LispAfiAddress getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.address, this.protocol, this.ipTos, this.localPortLow, this.localPortHigh, this.remotePortLow, this.remotePortHigh);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispAppDataLcafAddress) {
            LispAppDataLcafAddress other = (LispAppDataLcafAddress)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.ipTos, other.ipTos) && Objects.equals(this.localPortLow, other.localPortLow) && Objects.equals(this.localPortHigh, other.localPortHigh) && Objects.equals(this.remotePortLow, other.remotePortLow) && Objects.equals(this.remotePortHigh, other.remotePortHigh);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("protocol", (int)this.protocol).add("ip type of service", this.ipTos).add("low-ranged local port number", (int)this.localPortLow).add("high-ranged local port number", (int)this.localPortHigh).add("low-ranged remote port number", (int)this.remotePortLow).add("high-ranged remote port number", (int)this.remotePortHigh).toString();
    }

    public static class AppDataLcafAddressWriter
    implements LispAddressWriter<LispAppDataLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispAppDataLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byte[] tos = AppDataLcafAddressWriter.getPartialByteArray(address.getIpTos());
            byteBuf.writeBytes(tos);
            byteBuf.writeByte((int)address.getProtocol());
            byteBuf.writeShort((int)address.getLocalPortLow());
            byteBuf.writeShort((int)address.getLocalPortHigh());
            byteBuf.writeShort((int)address.getRemotePortLow());
            byteBuf.writeShort((int)address.getRemotePortHigh());
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, address.getAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }

        public static byte[] getPartialByteArray(int value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            byte[] array = buffer.putInt(value).array();
            return Arrays.copyOfRange(array, 1, 4);
        }
    }

    public static class AppDataLcafAddressReader
    implements LispAddressReader<LispAppDataLcafAddress> {
        @Override
        public LispAppDataLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            byte[] ipTosByte = new byte[3];
            byteBuf.readBytes(ipTosByte);
            byte protocol = (byte)byteBuf.readUnsignedByte();
            int ipTos = AppDataLcafAddressReader.getPartialInt(ipTosByte);
            short localPortLow = (short)byteBuf.readUnsignedShort();
            short localPortHigh = (short)byteBuf.readUnsignedShort();
            short remotePortLow = (short)byteBuf.readUnsignedShort();
            short remotePortHigh = (short)byteBuf.readUnsignedShort();
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new AppDataAddressBuilder().withProtocol(protocol).withIpTos(ipTos).withLocalPortLow(localPortLow).withLocalPortHigh(localPortHigh).withRemotePortLow(remotePortLow).withRemotePortHigh(remotePortHigh).withAddress(address).build();
        }

        public static int getPartialInt(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.position(4 - bytes.length);
            buffer.put(bytes);
            buffer.position(0);
            return buffer.getInt();
        }
    }

    public static final class AppDataAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<AppDataAddressBuilder> {
        private byte protocol;
        private int ipTos;
        private short localPortLow;
        private short localPortHigh;
        private short remotePortLow;
        private short remotePortHigh;
        private LispAfiAddress address;

        public AppDataAddressBuilder withProtocol(byte protocol) {
            this.protocol = protocol;
            return this;
        }

        public AppDataAddressBuilder withIpTos(int ipTos) {
            this.ipTos = ipTos;
            return this;
        }

        public AppDataAddressBuilder withLocalPortLow(short localPortLow) {
            this.localPortLow = localPortLow;
            return this;
        }

        public AppDataAddressBuilder withLocalPortHigh(short localPortHigh) {
            this.localPortHigh = localPortHigh;
            return this;
        }

        public AppDataAddressBuilder withRemotePortLow(short remotePortLow) {
            this.remotePortLow = remotePortLow;
            return this;
        }

        public AppDataAddressBuilder withRemotePortHigh(short remotePortHigh) {
            this.remotePortHigh = remotePortHigh;
            return this;
        }

        public AppDataAddressBuilder withAddress(LispAfiAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public LispAppDataLcafAddress build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Must specify an address");
            return new LispAppDataLcafAddress(this.reserved1, this.reserved2, this.flag, this.length, this.protocol, this.ipTos, this.localPortLow, this.localPortHigh, this.remotePortLow, this.remotePortHigh, this.address);
        }
    }
}

