/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import io.netty.buffer.ByteBuf;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;

public abstract class LispIpAddress
extends LispAfiAddress {
    protected final IpAddress address;

    protected LispIpAddress(IpAddress address, AddressFamilyIdentifierEnum afi) {
        super(afi);
        this.address = address;
    }

    public IpAddress getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.address.equals(obj);
    }

    public String toString() {
        return this.address.toString();
    }

    public static class IpAddressWriter
    implements LispAddressWriter<LispIpAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispIpAddress address) throws LispWriterException {
            if (address.getAddress().isIp4()) {
                new LispIpv4Address.Ipv4AddressWriter().writeTo(byteBuf, (LispIpv4Address)address);
            }
            if (address.getAddress().isIp6()) {
                new LispIpv6Address.Ipv6AddressWriter().writeTo(byteBuf, (LispIpv6Address)address);
            }
        }
    }

    public static class IpAddressReader
    implements LispAddressReader<LispIpAddress> {
        @Override
        public LispIpAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            short afiCode = (short)byteBuf.readUnsignedShort();
            if (afiCode == 1) {
                return new LispIpv4Address.Ipv4AddressReader().readFrom(byteBuf);
            }
            if (afiCode == 2) {
                return new LispIpv6Address.Ipv6AddressReader().readFrom(byteBuf);
            }
            return null;
        }
    }
}

