/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class LispEidRecord {
    private final byte maskLength;
    private final LispAfiAddress prefix;
    private final int hash;

    public LispEidRecord(byte maskLength, LispAfiAddress prefix) {
        this.maskLength = maskLength;
        Preconditions.checkNotNull((Object)prefix, (Object)"Must specify an address prefix");
        this.prefix = prefix;
        this.hash = 527 + Objects.hashCode((Object[])new Object[]{maskLength, prefix});
    }

    public byte getMaskLength() {
        return this.maskLength;
    }

    public LispAfiAddress getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maskLength", (int)this.maskLength).add("prefix", (Object)this.prefix).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LispEidRecord that = (LispEidRecord)o;
        return Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)this.prefix, (Object)that.prefix);
    }

    public int hashCode() {
        return this.hash;
    }

    public static final class EidRecordWriter
    implements LispMessageWriter<LispEidRecord> {
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispEidRecord message) throws LispWriterException {
            byteBuf.writeByte(0);
            byteBuf.writeByte((int)message.getMaskLength());
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getPrefix());
        }
    }

    public static final class EidRecordReader
    implements LispMessageReader<LispEidRecord> {
        private static final int RESERVED_SKIP_LENGTH = 1;

        @Override
        public LispEidRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            byteBuf.skipBytes(1);
            short maskLength = byteBuf.readUnsignedByte();
            LispAfiAddress prefix = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new LispEidRecord((byte)maskLength, prefix);
        }
    }
}

