/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispMapRequest
extends AbstractLispMessage
implements LispMapRequest {
    private final long nonce;
    private final LispAfiAddress sourceEid;
    private final List<LispAfiAddress> itrRlocs;
    private final List<LispEidRecord> eidRecords;
    private final boolean authoritative;
    private final boolean mapDataPresent;
    private final boolean probe;
    private final boolean smr;
    private final boolean pitr;
    private final boolean smrInvoked;
    private final int replyRecord;
    static final RequestWriter WRITER = new RequestWriter();

    private DefaultLispMapRequest(long nonce, LispAfiAddress sourceEid, List<LispAfiAddress> itrRlocs, List<LispEidRecord> eidRecords, boolean authoritative, boolean mapDataPresent, boolean probe, boolean smr, boolean pitr, boolean smrInvoked, int replyReocrd) {
        this.nonce = nonce;
        this.sourceEid = sourceEid;
        this.itrRlocs = itrRlocs;
        this.eidRecords = eidRecords;
        this.authoritative = authoritative;
        this.mapDataPresent = mapDataPresent;
        this.probe = probe;
        this.smr = smr;
        this.pitr = pitr;
        this.smrInvoked = smrInvoked;
        this.replyRecord = replyReocrd;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_MAP_REQUEST;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultRequestBuilder();
    }

    @Override
    public boolean isAuthoritative() {
        return this.authoritative;
    }

    @Override
    public boolean isMapDataPresent() {
        return this.mapDataPresent;
    }

    @Override
    public boolean isProbe() {
        return this.probe;
    }

    @Override
    public boolean isSmr() {
        return this.smr;
    }

    @Override
    public boolean isPitr() {
        return this.pitr;
    }

    @Override
    public boolean isSmrInvoked() {
        return this.smrInvoked;
    }

    @Override
    public int getRecordCount() {
        return this.eidRecords.size();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public LispAfiAddress getSourceEid() {
        return this.sourceEid;
    }

    @Override
    public List<LispAfiAddress> getItrRlocs() {
        return ImmutableList.copyOf(this.itrRlocs);
    }

    @Override
    public List<LispEidRecord> getEids() {
        return ImmutableList.copyOf(this.eidRecords);
    }

    @Override
    public int getReplyRecord() {
        return this.replyRecord;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("source EID", (Object)this.sourceEid).add("ITR rlocs", this.itrRlocs).add("EID records", this.eidRecords).add("authoritative", this.authoritative).add("mapDataPresent", this.mapDataPresent).add("probe", this.probe).add("SMR", this.smr).add("Proxy ITR", this.pitr).add("SMR Invoked", this.smrInvoked).add("Size of reply record", this.replyRecord).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapRequest that = (DefaultLispMapRequest)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.sourceEid, (Object)that.sourceEid) && Objects.equal((Object)this.authoritative, (Object)that.authoritative) && Objects.equal((Object)this.mapDataPresent, (Object)that.mapDataPresent) && Objects.equal((Object)this.probe, (Object)that.probe) && Objects.equal((Object)this.smr, (Object)that.smr) && Objects.equal((Object)this.pitr, (Object)that.pitr) && Objects.equal((Object)this.smrInvoked, (Object)that.smrInvoked) && Objects.equal((Object)this.replyRecord, (Object)that.replyRecord);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.sourceEid, this.authoritative, this.mapDataPresent, this.probe, this.smr, this.pitr, this.smrInvoked, this.replyRecord});
    }

    public static final class RequestWriter
    implements LispMessageWriter<LispMapRequest> {
        private static final int REQUEST_SHIFT_BIT = 4;
        private static final int AUTHORITATIVE_SHIFT_BIT = 3;
        private static final int MAP_DATA_PRESENT_SHIFT_BIT = 2;
        private static final int PROBE_SHIFT_BIT = 1;
        private static final int PITR_SHIFT_BIT = 7;
        private static final int SMR_INVOKED_SHIFT_BIT = 6;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapRequest message) throws LispWriterException {
            byte msgType = (byte)(LispType.LISP_MAP_REQUEST.getTypeCode() << 4);
            int authoritative = 0;
            if (message.isAuthoritative()) {
                authoritative = 8;
            }
            int mapDataPresent = 0;
            if (message.isMapDataPresent()) {
                mapDataPresent = 4;
            }
            int probe = 0;
            if (message.isProbe()) {
                probe = 2;
            }
            int smr = 0;
            if (message.isSmr()) {
                smr = 1;
            }
            byteBuf.writeByte((int)((byte)(msgType + authoritative + mapDataPresent + probe + smr)));
            int pitr = 0;
            if (message.isPitr()) {
                pitr = -128;
            }
            int smrInvoked = 0;
            if (message.isSmrInvoked()) {
                smrInvoked = 64;
            }
            byteBuf.writeByte((int)((byte)(pitr + smrInvoked)));
            byteBuf.writeByte((byte)message.getItrRlocs().size() - 1);
            byteBuf.writeByte(message.getEids().size());
            byteBuf.writeLong(message.getNonce());
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getSourceEid());
            List<LispAfiAddress> rlocs = message.getItrRlocs();
            for (int i = 0; i < rlocs.size(); ++i) {
                afiAddressWriter.writeTo(byteBuf, rlocs.get(i));
            }
            LispEidRecord.EidRecordWriter recordWriter = new LispEidRecord.EidRecordWriter();
            List<LispEidRecord> records = message.getEids();
            for (int i = 0; i < records.size(); ++i) {
                recordWriter.writeTo(byteBuf, records.get(i));
            }
            byteBuf.writeInt(message.getReplyRecord());
        }
    }

    public static final class RequestReader
    implements LispMessageReader<LispMapRequest> {
        private static final int AUTHORITATIVE_INDEX = 3;
        private static final int MAP_DATA_PRESENT_INDEX = 2;
        private static final int PROBE_INDEX = 1;
        private static final int SMR_INDEX = 0;
        private static final int PITR_INDEX = 7;
        private static final int SMR_INVOKED_INDEX = 6;

        @Override
        public LispMapRequest readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            byte typeWithFlags = byteBuf.readByte();
            boolean authoritative = ByteOperator.getBit((byte)typeWithFlags, (int)3);
            boolean mapDataPresent = ByteOperator.getBit((byte)typeWithFlags, (int)2);
            boolean probe = ByteOperator.getBit((byte)typeWithFlags, (int)1);
            boolean smr = ByteOperator.getBit((byte)typeWithFlags, (int)0);
            byte reservedWithFlags = byteBuf.readByte();
            boolean pitr = ByteOperator.getBit((byte)reservedWithFlags, (int)7);
            boolean smrInvoked = ByteOperator.getBit((byte)reservedWithFlags, (int)6);
            short irc = byteBuf.readUnsignedByte();
            int recordCount = byteBuf.readUnsignedByte();
            long nonce = byteBuf.readLong();
            LispAfiAddress sourceEid = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            ArrayList itrRlocs = Lists.newArrayList();
            for (int i = 0; i < irc + 1; ++i) {
                itrRlocs.add(new LispAfiAddress.AfiAddressReader().readFrom(byteBuf));
            }
            ArrayList eidRecords = Lists.newArrayList();
            for (int i = 0; i < recordCount; ++i) {
                eidRecords.add(new LispEidRecord.EidRecordReader().readFrom(byteBuf));
            }
            int replyRecord = 0;
            if (mapDataPresent) {
                replyRecord = byteBuf.readInt();
            }
            return new DefaultRequestBuilder().withIsAuthoritative(authoritative).withIsMapDataPresent(mapDataPresent).withIsProbe(probe).withIsSmr(smr).withIsPitr(pitr).withIsSmrInvoked(smrInvoked).withNonce(nonce).withSourceEid(sourceEid).withEidRecords(eidRecords).withItrRlocs(itrRlocs).withReplyRecord(replyRecord).build();
        }
    }

    public static final class DefaultRequestBuilder
    implements LispMapRequest.RequestBuilder {
        private long nonce;
        private LispAfiAddress sourceEid;
        private List<LispAfiAddress> itrRlocs = Lists.newArrayList();
        private List<LispEidRecord> eidRecords = Lists.newArrayList();
        private boolean authoritative;
        private boolean mapDataPresent;
        private boolean probe;
        private boolean smr;
        private boolean pitr;
        private boolean smrInvoked;
        private int replyRecord;

        @Override
        public LispType getType() {
            return LispType.LISP_MAP_REQUEST;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsAuthoritative(boolean authoritative) {
            this.authoritative = authoritative;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsProbe(boolean probe) {
            this.probe = probe;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsMapDataPresent(boolean mapDataPresent) {
            this.mapDataPresent = mapDataPresent;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsSmr(boolean smr) {
            this.smr = smr;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsPitr(boolean pitr) {
            this.pitr = pitr;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withIsSmrInvoked(boolean smrInvoked) {
            this.smrInvoked = smrInvoked;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withSourceEid(LispAfiAddress sourceEid) {
            this.sourceEid = sourceEid;
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withItrRlocs(List<LispAfiAddress> itrRlocs) {
            if (itrRlocs != null) {
                this.itrRlocs = ImmutableList.copyOf(itrRlocs);
            }
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withEidRecords(List<LispEidRecord> records) {
            if (records != null) {
                this.eidRecords = ImmutableList.copyOf(records);
            }
            return this;
        }

        @Override
        public LispMapRequest.RequestBuilder withReplyRecord(int replyRecord) {
            this.replyRecord = replyRecord;
            return this;
        }

        @Override
        public LispMapRequest build() {
            Preconditions.checkArgument((this.itrRlocs != null && !this.itrRlocs.isEmpty() ? 1 : 0) != 0, (Object)"Must have an ITR RLOC entry");
            return new DefaultLispMapRequest(this.nonce, this.sourceEid, this.itrRlocs, this.eidRecords, this.authoritative, this.mapDataPresent, this.probe, this.smr, this.pitr, this.smrInvoked, this.replyRecord);
        }
    }
}

