/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.DeserializationException;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.DefaultLispReferralRecord;
import org.onosproject.lisp.msg.protocols.LispMapReferral;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispReferralRecord;
import org.onosproject.lisp.msg.protocols.LispType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLispMapReferral
extends AbstractLispMessage
implements LispMapReferral {
    private static final Logger log = LoggerFactory.getLogger(DefaultLispMapReferral.class);
    private final long nonce;
    private final List<LispReferralRecord> referralRecords;
    static final MapReferralWriter WRITER = new MapReferralWriter();

    private DefaultLispMapReferral(long nonce, List<LispReferralRecord> referralRecords) {
        this.nonce = nonce;
        this.referralRecords = referralRecords;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_MAP_REFERRAL;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultMapReferralBuilder();
    }

    @Override
    public int getRecordCount() {
        return this.referralRecords.size();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public List<LispReferralRecord> getReferralRecords() {
        return ImmutableList.copyOf(this.referralRecords);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("referralRecords", this.referralRecords).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapReferral that = (DefaultLispMapReferral)o;
        return Objects.equals(this.nonce, that.nonce);
    }

    public int hashCode() {
        return Objects.hashCode(this.nonce);
    }

    public static final class MapReferralWriter
    implements LispMessageWriter<LispMapReferral> {
        private static final int REFERRAL_SHIFT_BIT = 4;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapReferral message) throws LispWriterException {
            byte msgType = (byte)(LispType.LISP_MAP_REFERRAL.getTypeCode() << 4);
            byteBuf.writeShort(0);
            byteBuf.writeByte(0);
            byteBuf.writeByte(message.getReferralRecords().size());
            byteBuf.writeLong(message.getNonce());
            DefaultLispReferralRecord.ReferralRecordWriter writer = new DefaultLispReferralRecord.ReferralRecordWriter();
            List<LispReferralRecord> records = message.getReferralRecords();
            for (int i = 0; i < records.size(); ++i) {
                writer.writeTo(byteBuf, records.get(i));
            }
        }
    }

    public static final class MapReferralReader
    implements LispMessageReader<LispMapReferral> {
        private static final int RESERVED_SKIP_LENGTH = 3;

        @Override
        public LispMapReferral readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException, DeserializationException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            byteBuf.skipBytes(3);
            int recordCount = byteBuf.readUnsignedByte();
            long nonce = byteBuf.readLong();
            ArrayList referralRecords = Lists.newArrayList();
            for (int i = 0; i < recordCount; ++i) {
                referralRecords.add(new DefaultLispReferralRecord.ReferralRecordReader().readFrom(byteBuf));
            }
            return new DefaultMapReferralBuilder().withNonce(nonce).withReferralRecords(referralRecords).build();
        }
    }

    public static final class DefaultMapReferralBuilder
    implements LispMapReferral.MapReferralBuilder {
        private long nonce;
        private List<LispReferralRecord> referralRecords = Lists.newArrayList();

        @Override
        public LispType getType() {
            return LispType.LISP_MAP_REFERRAL;
        }

        @Override
        public LispMapReferral.MapReferralBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispMapReferral.MapReferralBuilder withReferralRecords(List<LispReferralRecord> records) {
            if (this.referralRecords != null) {
                this.referralRecords = ImmutableList.copyOf(records);
            }
            return this;
        }

        @Override
        public LispMapReferral build() {
            return new DefaultLispMapReferral(this.nonce, this.referralRecords);
        }
    }
}

