/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispLocator;
import org.onosproject.lisp.msg.protocols.LispLocator;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispMapRecord
extends AbstractLispRecord
implements LispMapRecord {
    private final List<LispLocator> locators;
    static final MapRecordWriter WRITER = new MapRecordWriter();

    private DefaultLispMapRecord(int recordTtl, byte maskLength, LispMapReplyAction action, boolean authoritative, short mapVersionNumber, LispAfiAddress eidPrefixAfi, List<LispLocator> locators) {
        super(recordTtl, maskLength, action, authoritative, mapVersionNumber, eidPrefixAfi);
        this.locators = locators;
    }

    @Override
    public int getLocatorCount() {
        return this.locators.size();
    }

    @Override
    public List<LispLocator> getLocators() {
        return ImmutableList.copyOf(this.locators);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("record TTL", this.recordTtl).add("maskLength", (int)this.maskLength).add("action", (Object)this.action).add("authoritative", this.authoritative).add("mapVersionNumber", (int)this.mapVersionNumber).add("EID prefix AFI address", (Object)this.eidPrefixAfi).add("locators", this.locators).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapRecord that = (DefaultLispMapRecord)o;
        return Objects.equal((Object)this.recordTtl, (Object)that.recordTtl) && Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal((Object)this.authoritative, (Object)that.authoritative) && Objects.equal((Object)this.mapVersionNumber, (Object)that.mapVersionNumber) && Objects.equal((Object)this.eidPrefixAfi, (Object)that.eidPrefixAfi) && Objects.equal(this.locators, that.locators);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.locators});
    }

    public static final class MapRecordWriter
    implements LispMessageWriter<LispMapRecord> {
        private static final int REPLY_ACTION_SHIFT_BIT = 5;
        private static final int AUTHORITATIVE_FLAG_SHIFT_BIT = 4;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapRecord message) throws LispWriterException {
            byteBuf.writeInt(message.getRecordTtl());
            byteBuf.writeByte((int)((byte)message.getLocators().size()));
            byteBuf.writeByte((int)message.getMaskLength());
            byte action = (byte)(message.getAction().getAction() << 5);
            int authoritative = 0;
            if (message.isAuthoritative()) {
                authoritative = 16;
            }
            byteBuf.writeByte((int)((byte)(action + authoritative)));
            byteBuf.writeByte(0);
            byteBuf.writeShort((int)message.getMapVersionNumber());
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getEidPrefixAfi());
            DefaultLispLocator.LocatorWriter recordWriter = new DefaultLispLocator.LocatorWriter();
            List<LispLocator> locators = message.getLocators();
            for (int i = 0; i < locators.size(); ++i) {
                recordWriter.writeTo(byteBuf, locators.get(i));
            }
        }
    }

    public static final class MapRecordReader
    implements LispMessageReader<LispMapRecord> {
        private static final int AUTHORITATIVE_INDEX = 4;
        private static final int RESERVED_SKIP_LENGTH = 1;
        private static final int REPLY_ACTION_SHIFT_BIT = 5;

        @Override
        public LispMapRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            int recordTtl = byteBuf.readInt();
            int locatorCount = byteBuf.readUnsignedByte();
            byte maskLength = (byte)byteBuf.readUnsignedByte();
            byte actionWithFlag = (byte)byteBuf.readUnsignedByte();
            int actionByte = actionWithFlag >> 5;
            LispMapReplyAction action = LispMapReplyAction.valueOf(actionByte);
            if (action == null) {
                action = LispMapReplyAction.NoAction;
            }
            boolean authoritative = ByteOperator.getBit((byte)((byte)(actionWithFlag >> 4)), (int)0);
            byteBuf.skipBytes(1);
            short mapVersionNumber = (short)byteBuf.readUnsignedShort();
            LispAfiAddress eidPrefixAfi = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            ArrayList locators = Lists.newArrayList();
            for (int i = 0; i < locatorCount; ++i) {
                locators.add(new DefaultLispLocator.LocatorReader().readFrom(byteBuf));
            }
            return ((LispMapRecord.MapRecordBuilder)((LispMapRecord.MapRecordBuilder)((LispMapRecord.MapRecordBuilder)((LispMapRecord.MapRecordBuilder)((LispMapRecord.MapRecordBuilder)((LispMapRecord.MapRecordBuilder)new DefaultMapRecordBuilder().withRecordTtl(recordTtl)).withMaskLength(maskLength)).withAction(action)).withIsAuthoritative(authoritative)).withMapVersionNumber(mapVersionNumber)).withLocators(locators).withEidPrefixAfi(eidPrefixAfi)).build();
        }
    }

    public static final class DefaultMapRecordBuilder
    extends AbstractLispRecord.AbstractRecordBuilder<LispMapRecord.MapRecordBuilder>
    implements LispMapRecord.MapRecordBuilder {
        private List<LispLocator> locators = Lists.newArrayList();

        @Override
        public LispMapRecord.MapRecordBuilder withLocators(List<LispLocator> locators) {
            if (locators != null) {
                this.locators = ImmutableList.copyOf(locators);
            }
            return this;
        }

        @Override
        public LispMapRecord build() {
            Preconditions.checkNotNull((Object)this.eidPrefixAfi, (Object)"Must specify an EID prefix");
            return new DefaultLispMapRecord(this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.locators);
        }
    }
}

