/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.lisp.msg.authentication.LispAuthenticationFactory;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapNotify;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLispMapNotify
extends AbstractLispMessage
implements LispMapNotify {
    private static final Logger log = LoggerFactory.getLogger(DefaultLispMapNotify.class);
    private final long nonce;
    private final short keyId;
    private final short authDataLength;
    private final byte[] authData;
    private final List<LispMapRecord> mapRecords;
    static final NotifyWriter WRITER = new NotifyWriter();

    private DefaultLispMapNotify(long nonce, short keyId, short authDataLength, byte[] authData, List<LispMapRecord> mapRecords) {
        this.nonce = nonce;
        this.keyId = keyId;
        this.authDataLength = authDataLength;
        this.authData = authData;
        this.mapRecords = mapRecords;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_MAP_NOTIFY;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultNotifyBuilder();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public int getRecordCount() {
        return this.mapRecords.size();
    }

    @Override
    public short getKeyId() {
        return this.keyId;
    }

    @Override
    public short getAuthDataLength() {
        return this.authDataLength;
    }

    @Override
    public byte[] getAuthData() {
        if (this.authData != null && this.authData.length != 0) {
            return ImmutableByteSequence.copyFrom((byte[])this.authData).asArray();
        }
        return new byte[0];
    }

    @Override
    public List<LispMapRecord> getMapRecords() {
        return ImmutableList.copyOf(this.mapRecords);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("keyId", (int)this.keyId).add("authentication data length", (int)this.authDataLength).add("authentication data", (Object)this.authData).add("mapRecords", this.mapRecords).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapNotify that = (DefaultLispMapNotify)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.keyId, (Object)that.keyId) && Objects.equal((Object)this.authDataLength, (Object)that.authDataLength) && Arrays.equals(this.authData, that.authData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.keyId, this.authDataLength}) + Arrays.hashCode(this.authData);
    }

    public static final class NotifyWriter
    implements LispMessageWriter<LispMapNotify> {
        private static final int NOTIFY_SHIFT_BIT = 4;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapNotify message) throws LispWriterException {
            byte msgType = (byte)(LispType.LISP_MAP_NOTIFY.getTypeCode() << 4);
            byteBuf.writeByte((int)msgType);
            byteBuf.writeShort(0);
            byteBuf.writeByte(message.getMapRecords().size());
            byteBuf.writeLong(message.getNonce());
            byteBuf.writeShort((int)message.getKeyId());
            if (message.getAuthData() == null) {
                byteBuf.writeShort(0);
            } else {
                byteBuf.writeShort(message.getAuthData().length);
                byteBuf.writeBytes(message.getAuthData());
            }
            DefaultLispMapRecord.MapRecordWriter writer = new DefaultLispMapRecord.MapRecordWriter();
            List<LispMapRecord> records = message.getMapRecords();
            for (int i = 0; i < records.size(); ++i) {
                writer.writeTo(byteBuf, records.get(i));
            }
        }
    }

    public static final class NotifyReader
    implements LispMessageReader<LispMapNotify> {
        private static final int RESERVED_SKIP_LENGTH = 3;

        @Override
        public LispMapNotify readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            byteBuf.skipBytes(3);
            int recordCount = byteBuf.readUnsignedByte();
            long nonce = byteBuf.readLong();
            short keyId = byteBuf.readShort();
            short authLength = byteBuf.readShort();
            byte[] authData = new byte[authLength];
            byteBuf.readBytes(authData);
            ArrayList mapRecords = Lists.newArrayList();
            for (int i = 0; i < recordCount; ++i) {
                mapRecords.add(new DefaultLispMapRecord.MapRecordReader().readFrom(byteBuf));
            }
            return new DefaultNotifyBuilder().withNonce(nonce).withKeyId(keyId).withAuthDataLength(authLength).withAuthData(authData).withMapRecords(mapRecords).build();
        }
    }

    public static final class DefaultNotifyBuilder
    implements LispMapNotify.NotifyBuilder {
        private long nonce;
        private short keyId;
        private short authDataLength;
        private byte[] authData;
        private String authKey;
        private List<LispMapRecord> mapRecords = Lists.newArrayList();

        @Override
        public LispType getType() {
            return LispType.LISP_MAP_NOTIFY;
        }

        @Override
        public LispMapNotify.NotifyBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispMapNotify.NotifyBuilder withKeyId(short keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public LispMapNotify.NotifyBuilder withAuthKey(String key) {
            this.authKey = key;
            return this;
        }

        @Override
        public LispMapNotify.NotifyBuilder withAuthDataLength(short authDataLength) {
            this.authDataLength = authDataLength;
            return this;
        }

        @Override
        public LispMapNotify.NotifyBuilder withAuthData(byte[] authData) {
            this.authData = authData != null ? authData : new byte[0];
            return this;
        }

        @Override
        public LispMapNotify.NotifyBuilder withMapRecords(List<LispMapRecord> mapRecords) {
            if (mapRecords != null) {
                this.mapRecords = ImmutableList.copyOf(mapRecords);
            }
            return this;
        }

        @Override
        public LispMapNotify build() {
            if (this.authData == null) {
                LispAuthenticationFactory factory = LispAuthenticationFactory.getInstance();
                this.authDataLength = LispAuthenticationKeyEnum.valueOf(this.keyId).getHashLength();
                byte[] tmpAuthData = new byte[this.authDataLength];
                Arrays.fill(tmpAuthData, (byte)0);
                this.authData = tmpAuthData;
                ByteBuf byteBuf = Unpooled.buffer();
                try {
                    new DefaultLispMapNotify(this.nonce, this.keyId, this.authDataLength, this.authData, this.mapRecords).writeTo(byteBuf);
                }
                catch (LispWriterException e) {
                    log.warn("Failed to serialize map notify message", (Throwable)e);
                }
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                if (this.authKey == null) {
                    log.warn("Must specify authentication key");
                }
                this.authData = factory.createAuthenticationData(LispAuthenticationKeyEnum.valueOf(this.keyId), this.authKey, bytes);
            }
            return new DefaultLispMapNotify(this.nonce, this.keyId, this.authDataLength, this.authData, this.mapRecords);
        }
    }
}

