/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispGenericLocator;
import org.onosproject.lisp.msg.protocols.LispGenericLocator;
import org.onosproject.lisp.msg.protocols.LispLocator;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispLocator
extends DefaultLispGenericLocator
implements LispLocator {
    static final LocatorWriter WRITER = new LocatorWriter();

    private DefaultLispLocator(byte priority, byte weight, byte multicastPriority, byte multicastWeight, boolean localLocator, boolean rlocProbed, boolean routed, LispAfiAddress locatorAfi) {
        super(priority, weight, multicastPriority, multicastWeight, localLocator, rlocProbed, routed, locatorAfi);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public static final class LocatorWriter
    implements LispMessageWriter<LispLocator> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispLocator message) throws LispWriterException {
            DefaultLispGenericLocator.serialize(byteBuf, message);
        }
    }

    public static final class LocatorReader
    implements LispMessageReader<LispLocator> {
        @Override
        public LispLocator readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispGenericLocator gl = DefaultLispGenericLocator.deserialize(byteBuf);
            return ((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)((LispLocator.LocatorBuilder)new DefaultLocatorBuilder().withPriority(gl.getPriority())).withWeight(gl.getWeight())).withMulticastPriority(gl.getMulticastPriority())).withMulticastWeight(gl.getMulticastWeight())).withLocalLocator(gl.isLocalLocator())).withRouted(gl.isRouted())).withLocatorAfi(gl.getLocatorAfi())).build();
        }
    }

    public static final class DefaultLocatorBuilder
    extends DefaultLispGenericLocator.AbstractGenericLocatorBuilder<LispLocator.LocatorBuilder>
    implements LispLocator.LocatorBuilder {
        @Override
        public LispLocator build() {
            Preconditions.checkNotNull((Object)this.locatorAfi, (Object)"Must specify a locator address");
            return new DefaultLispLocator(this.priority, this.weight, this.multicastPriority, this.multicastWeight, this.localLocator, this.rlocProbed, this.routed, this.locatorAfi);
        }
    }
}

