/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.onosproject.lisp.msg.authentication.LispAuthenticationFactory;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispInfo;
import org.onosproject.lisp.msg.protocols.LispInfo;
import org.onosproject.lisp.msg.protocols.LispInfoReply;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNatLcafAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLispInfoReply
extends DefaultLispInfo
implements LispInfoReply {
    private static final Logger log = LoggerFactory.getLogger(DefaultLispInfoReply.class);
    private final LispNatLcafAddress natLcafAddress;
    static final InfoReplyWriter WRITER = new InfoReplyWriter();

    protected DefaultLispInfoReply(boolean infoReply, long nonce, short keyId, short authDataLength, byte[] authData, int ttl, byte maskLength, LispAfiAddress eidPrefix, LispNatLcafAddress natLcafAddress) {
        super(infoReply, nonce, keyId, authDataLength, authData, ttl, maskLength, eidPrefix);
        this.natLcafAddress = natLcafAddress;
    }

    @Override
    public LispNatLcafAddress getNatLcafAddress() {
        return this.natLcafAddress;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("keyId", (int)this.keyId).add("authentication data length", (int)this.authDataLength).add("authentication data", (Object)this.authData).add("TTL", this.ttl).add("EID mask length", (int)this.maskLength).add("EID prefix", (Object)this.eidPrefix).add("NAT LCAF address", (Object)this.natLcafAddress).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispInfoReply that = (DefaultLispInfoReply)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.keyId, (Object)that.keyId) && Objects.equal((Object)this.authDataLength, (Object)that.authDataLength) && Arrays.equals(this.authData, that.authData) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)this.eidPrefix, (Object)that.eidPrefix) && Objects.equal((Object)this.natLcafAddress, (Object)that.natLcafAddress);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.keyId, this.authDataLength, this.ttl, this.maskLength, this.eidPrefix, this.natLcafAddress}) + Arrays.hashCode(this.authData);
    }

    public static final class InfoReplyWriter
    implements LispMessageWriter<LispInfoReply> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispInfoReply message) throws LispWriterException {
            DefaultLispInfo.serialize(byteBuf, message);
            new LispLcafAddress.LcafAddressWriter().writeTo(byteBuf, message.getNatLcafAddress());
        }
    }

    public static final class InfoReplyReader
    implements LispMessageReader<LispInfoReply> {
        @Override
        public LispInfoReply readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispInfo lispInfo = DefaultLispInfo.deserialize(byteBuf);
            LispNatLcafAddress natLcafAddress = (LispNatLcafAddress)new LispLcafAddress.LcafAddressReader().readFrom(byteBuf);
            return ((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)new DefaultInfoReplyBuilder().withIsInfoReply(lispInfo.isInfoReply()).withNonce(lispInfo.getNonce())).withKeyId(lispInfo.getKeyId())).withAuthDataLength(lispInfo.getAuthDataLength())).withAuthData(lispInfo.getAuthData())).withTtl(lispInfo.getTtl())).withMaskLength(lispInfo.getMaskLength())).withEidPrefix(lispInfo.getPrefix())).withNatLcafAddress(natLcafAddress).build();
        }
    }

    public static final class DefaultInfoReplyBuilder
    implements LispInfoReply.InfoReplyBuilder {
        private boolean infoReply;
        private long nonce;
        private short keyId;
        private short authDataLength;
        private byte[] authData;
        private String authKey;
        private int ttl;
        private byte maskLength;
        private LispAfiAddress eidPrefix;
        private LispNatLcafAddress natLcafAddress;

        @Override
        public LispType getType() {
            return LispType.LISP_INFO;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withIsInfoReply(boolean infoReply) {
            this.infoReply = infoReply;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withAuthDataLength(short authDataLength) {
            this.authDataLength = authDataLength;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withKeyId(short keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withAuthData(byte[] authenticationData) {
            if (authenticationData != null) {
                this.authData = authenticationData;
            }
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withAuthKey(String key) {
            this.authKey = key;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withTtl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withMaskLength(byte maskLength) {
            this.maskLength = maskLength;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withEidPrefix(LispAfiAddress eidPrefix) {
            this.eidPrefix = eidPrefix;
            return this;
        }

        @Override
        public LispInfoReply.InfoReplyBuilder withNatLcafAddress(LispNatLcafAddress natLcafAddress) {
            this.natLcafAddress = natLcafAddress;
            return this;
        }

        @Override
        public LispInfoReply build() {
            if (this.authData == null) {
                LispAuthenticationFactory factory = LispAuthenticationFactory.getInstance();
                this.authDataLength = LispAuthenticationKeyEnum.valueOf(this.keyId).getHashLength();
                byte[] tmpAuthData = new byte[this.authDataLength];
                Arrays.fill(tmpAuthData, (byte)0);
                this.authData = tmpAuthData;
                ByteBuf byteBuf = Unpooled.buffer();
                try {
                    new DefaultLispInfoReply(this.infoReply, this.nonce, this.keyId, this.authDataLength, this.authData, this.ttl, this.maskLength, this.eidPrefix, this.natLcafAddress).writeTo(byteBuf);
                }
                catch (LispWriterException e) {
                    log.warn("Failed to serialize info reply", (Throwable)e);
                }
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                if (this.authKey == null) {
                    log.warn("Must specify authentication key");
                }
                this.authData = factory.createAuthenticationData(LispAuthenticationKeyEnum.valueOf(this.keyId), this.authKey, bytes);
            }
            return new DefaultLispInfoReply(this.infoReply, this.nonce, this.keyId, this.authDataLength, this.authData, this.ttl, this.maskLength, this.eidPrefix, this.natLcafAddress);
        }
    }
}

