/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.LispGenericLocator;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class DefaultLispGenericLocator
implements LispGenericLocator {
    protected final byte priority;
    protected final byte weight;
    protected final byte multicastPriority;
    protected final byte multicastWeight;
    protected final boolean localLocator;
    protected final boolean rlocProbed;
    protected final boolean routed;
    protected final LispAfiAddress locatorAfi;
    private static final int LOCAL_LOCATOR_SHIFT_BIT = 2;
    private static final int PROBED_SHIFT_BIT = 1;
    private static final int ENABLE_BIT = 1;
    private static final int DISABLE_BIT = 0;
    private static final int SKIP_UNUSED_FLAG_LENGTH = 1;
    private static final int LOCAL_LOCATOR_INDEX = 2;
    private static final int RLOC_PROBED_INDEX = 1;
    private static final int ROUTED_INDEX = 0;

    protected DefaultLispGenericLocator(byte priority, byte weight, byte multicastPriority, byte multicastWeight, boolean localLocator, boolean rlocProbed, boolean routed, LispAfiAddress locatorAfi) {
        this.priority = priority;
        this.weight = weight;
        this.multicastPriority = multicastPriority;
        this.multicastWeight = multicastWeight;
        this.localLocator = localLocator;
        this.rlocProbed = rlocProbed;
        this.routed = routed;
        this.locatorAfi = locatorAfi;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public byte getWeight() {
        return this.weight;
    }

    @Override
    public byte getMulticastPriority() {
        return this.multicastPriority;
    }

    @Override
    public byte getMulticastWeight() {
        return this.multicastWeight;
    }

    @Override
    public boolean isLocalLocator() {
        return this.localLocator;
    }

    @Override
    public boolean isRlocProbed() {
        return this.rlocProbed;
    }

    @Override
    public boolean isRouted() {
        return this.routed;
    }

    @Override
    public LispAfiAddress getLocatorAfi() {
        return this.locatorAfi;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("priority", (int)this.priority).add("weight", (int)this.weight).add("multi-cast priority", (int)this.multicastPriority).add("multi-cast weight", (int)this.multicastWeight).add("local locator", this.localLocator).add("RLOC probed", this.rlocProbed).add("routed", this.routed).add("locator AFI", (Object)this.locatorAfi).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispGenericLocator that = (DefaultLispGenericLocator)o;
        return Objects.equal((Object)this.priority, (Object)that.priority) && Objects.equal((Object)this.weight, (Object)that.weight) && Objects.equal((Object)this.multicastPriority, (Object)that.multicastPriority) && Objects.equal((Object)this.multicastWeight, (Object)that.multicastWeight) && Objects.equal((Object)this.localLocator, (Object)that.localLocator) && Objects.equal((Object)this.rlocProbed, (Object)that.rlocProbed) && Objects.equal((Object)this.routed, (Object)that.routed) && Objects.equal((Object)this.locatorAfi, (Object)that.locatorAfi);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.weight, this.multicastPriority, this.multicastWeight, this.localLocator, this.rlocProbed, this.routed, this.locatorAfi});
    }

    public static LispGenericLocator deserialize(ByteBuf byteBuf) throws LispParseError, LispReaderException {
        byte priority = (byte)byteBuf.readUnsignedByte();
        byte weight = (byte)byteBuf.readUnsignedByte();
        byte multicastPriority = (byte)byteBuf.readUnsignedByte();
        byte multicastWeight = (byte)byteBuf.readUnsignedByte();
        byteBuf.skipBytes(1);
        byte flags = byteBuf.readByte();
        boolean localLocator = ByteOperator.getBit((byte)flags, (int)2);
        boolean rlocProbed = ByteOperator.getBit((byte)flags, (int)1);
        boolean routed = ByteOperator.getBit((byte)flags, (int)0);
        LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
        return new DefaultLispGenericLocator(priority, weight, multicastPriority, multicastWeight, localLocator, rlocProbed, routed, address);
    }

    public static void serialize(ByteBuf byteBuf, LispGenericLocator genericLocator) throws LispWriterException {
        byteBuf.writeByte((int)genericLocator.getPriority());
        byteBuf.writeByte((int)genericLocator.getWeight());
        byteBuf.writeByte((int)genericLocator.getMulticastPriority());
        byteBuf.writeByte((int)genericLocator.getMulticastWeight());
        byteBuf.writeByte(0);
        int localLocator = 0;
        if (genericLocator.isLocalLocator()) {
            localLocator = 4;
        }
        int probed = 0;
        if (genericLocator.isRlocProbed()) {
            probed = 2;
        }
        int routed = 0;
        if (genericLocator.isRouted()) {
            routed = 1;
        }
        byteBuf.writeByte((int)((byte)(localLocator + probed + routed)));
        LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
        afiAddressWriter.writeTo(byteBuf, genericLocator.getLocatorAfi());
    }

    public static abstract class AbstractGenericLocatorBuilder<T>
    implements LispGenericLocator.GenericLocatorBuilder<T> {
        protected byte priority;
        protected byte weight;
        protected byte multicastPriority;
        protected byte multicastWeight;
        protected boolean localLocator;
        protected boolean rlocProbed;
        protected boolean routed;
        protected LispAfiAddress locatorAfi;

        @Override
        public T withPriority(byte priority) {
            this.priority = priority;
            return (T)this;
        }

        @Override
        public T withWeight(byte weight) {
            this.weight = weight;
            return (T)this;
        }

        @Override
        public T withMulticastPriority(byte priority) {
            this.multicastPriority = priority;
            return (T)this;
        }

        @Override
        public T withMulticastWeight(byte weight) {
            this.multicastWeight = weight;
            return (T)this;
        }

        @Override
        public T withLocalLocator(boolean localLocator) {
            this.localLocator = localLocator;
            return (T)this;
        }

        @Override
        public T withRlocProbed(boolean rlocProbed) {
            this.rlocProbed = rlocProbed;
            return (T)this;
        }

        @Override
        public T withRouted(boolean routed) {
            this.routed = routed;
            return (T)this;
        }

        @Override
        public T withLocatorAfi(LispAfiAddress locatorAfi) {
            this.locatorAfi = locatorAfi;
            return (T)this;
        }
    }
}

