/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.Annotation;
import org.onosproject.yang.runtime.DefaultAnnotatedNodeInfo;
import org.onosproject.yang.runtime.DefaultAnnotation;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.utils.SerializerUtilException;

public final class SerializersUtil {
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final String QUOTES = "\"";
    private static final String ROOT_ELEMENT_START = "<root ";
    private static final String ROOT_ELEMENT_END = "</root>";
    private static final String URI_ENCODING_CHAR_SET = "ISO-8859-1";
    private static final String ERROR_LIST_MSG = "List/Leaf-list node should be in format \"nodeName=key\"or \"nodeName=instance-value\"";
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String SLASH = "/";

    private SerializersUtil() {
    }

    public static AnnotatedNodeInfo convertXmlAttributesToAnnotations(Element element, ResourceId id) {
        Iterator iter = element.attributeIterator();
        if (!iter.hasNext()) {
            return null;
        }
        DefaultAnnotatedNodeInfo.Builder builder = DefaultAnnotatedNodeInfo.builder();
        builder = builder.resourceId(id);
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            DefaultAnnotation annotation = new DefaultAnnotation(attr.getQualifiedName(), attr.getValue());
            builder = builder.addAnnotation((Annotation)annotation);
        }
        return builder.build();
    }

    public static String addRootElementWithAnnotation(InputStream inputStream, List<Annotation> protocolAnnotation) throws DocumentException, IOException {
        String xmlData;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((xmlData = br.readLine()) != null) {
            sb.append(xmlData);
        }
        StringBuilder rootElement = new StringBuilder(ROOT_ELEMENT_START);
        if (protocolAnnotation != null) {
            for (Annotation annotation : protocolAnnotation) {
                rootElement.append(annotation.name()).append(EQUAL).append(QUOTES).append(annotation.value()).append(QUOTES);
            }
        }
        rootElement.append(">").append(sb.toString()).append(ROOT_ELEMENT_END);
        return rootElement.toString();
    }

    public static ResourceId.Builder convertUriToRid(String uriString, YangSerializerContext context) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        List<String> paths = SerializersUtil.urlPathArgsDecode(SLASH_SPLITTER.split((CharSequence)uriString));
        if (!paths.isEmpty()) {
            ResourceId.Builder ridBuilder = SerializerHelper.initializeResourceId((YangSerializerContext)context);
            SerializersUtil.processPathSegments(paths, ridBuilder);
            return ridBuilder;
        }
        return null;
    }

    public static List<String> urlPathArgsDecode(Iterable<String> paths) {
        try {
            ArrayList<String> decodedPathArgs = new ArrayList<String>();
            for (String pathArg : paths) {
                String decode = URLDecoder.decode(pathArg, URI_ENCODING_CHAR_SET);
                decodedPathArgs.add(decode);
            }
            return decodedPathArgs;
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerUtilException("Invalid URL path arg '" + paths + "': ", e);
        }
    }

    private static ResourceId.Builder processPathSegments(List<String> paths, ResourceId.Builder builder) {
        if (paths.isEmpty()) {
            return builder;
        }
        boolean isLastSegment = paths.size() == 1;
        String segment = paths.iterator().next();
        SerializersUtil.processSinglePathSegment(segment, builder);
        if (isLastSegment) {
            return builder;
        }
        List<String> remainPaths = paths.subList(1, paths.size());
        SerializersUtil.processPathSegments(remainPaths, builder);
        return builder;
    }

    private static void processSinglePathSegment(String pathSegment, ResourceId.Builder builder) {
        String name = SerializersUtil.getPreSegment(pathSegment, EQUAL);
        if (name != null) {
            String c = SerializersUtil.getPreSegment(name, COLON);
            if (c == null) {
                SerializersUtil.processPathSegmentWithoutNamespace(pathSegment, builder);
            }
        } else if (pathSegment.contains(COLON)) {
            SerializersUtil.processPathSegmentWithNamespace(pathSegment, builder);
        } else {
            SerializersUtil.processPathSegmentWithoutNamespace(pathSegment, builder);
        }
    }

    private static void processPathSegmentWithNamespace(String pathSegment, ResourceId.Builder builder) {
        String nodeName = SerializersUtil.getLatterSegment(pathSegment, COLON);
        String namespace = SerializersUtil.getPreSegment(pathSegment, COLON);
        SerializersUtil.addNodeNameToRid(nodeName, namespace, builder);
    }

    private static void processPathSegmentWithoutNamespace(String nodeName, ResourceId.Builder builder) {
        SerializersUtil.addNodeNameToRid(nodeName, null, builder);
    }

    private static void addNodeNameToRid(String nodeName, String namespace, ResourceId.Builder builder) {
        if (nodeName.contains(EQUAL)) {
            SerializersUtil.addListOrLeafList(nodeName, namespace, builder);
        } else {
            SerializersUtil.addLeaf(nodeName, namespace, builder);
        }
    }

    private static void addListOrLeafList(String path, String namespace, ResourceId.Builder builder) {
        String nodeName = SerializersUtil.getPreSegment(path, EQUAL);
        String keyStr = SerializersUtil.getLatterSegment(path, EQUAL);
        if (keyStr == null) {
            throw new SerializerUtilException(ERROR_LIST_MSG);
        }
        if (keyStr.contains(COMMA)) {
            ArrayList keys = Lists.newArrayList((Iterable)COMMA_SPLITTER.split((CharSequence)keyStr));
            SerializerHelper.addToResourceId((ResourceId.Builder)builder, (String)nodeName, (String)namespace, (List)keys);
        } else {
            SerializerHelper.addToResourceId((ResourceId.Builder)builder, (String)nodeName, (String)namespace, (List)Lists.newArrayList((Object[])new String[]{keyStr}));
        }
    }

    private static void addLeaf(String nodeName, String namespace, ResourceId.Builder builder) {
        Preconditions.checkNotNull((Object)nodeName);
        String value = null;
        SerializerHelper.addToResourceId((ResourceId.Builder)builder, (String)nodeName, (String)namespace, value);
    }

    public static String getPreSegment(String path, String splitChar) {
        int idx = path.lastIndexOf(splitChar);
        if (idx == -1) {
            return null;
        }
        return path.substring(0, idx);
    }

    public static String getLatterSegment(String path, String splitChar) {
        int idx = path.lastIndexOf(splitChar);
        if (idx == -1) {
            return path;
        }
        return path.substring(idx + 1);
    }

    public static String convertRidToUri(ResourceId rid) {
        if (rid == null) {
            return null;
        }
        StringBuilder uriBuilder = new StringBuilder();
        List nodeKeyList = rid.nodeKeys();
        String curNameSpace = null;
        for (NodeKey key : nodeKeyList) {
            curNameSpace = SerializersUtil.addNodeKeyToUri(key, curNameSpace, uriBuilder);
        }
        return uriBuilder.toString();
    }

    private static String addNodeKeyToUri(NodeKey key, String curNameSpace, StringBuilder uriBuilder) {
        String newNameSpace;
        if (key instanceof LeafListKey) {
            newNameSpace = SerializersUtil.addLeafListNodeToUri((LeafListKey)key, curNameSpace, uriBuilder);
        } else if (key instanceof ListKey) {
            newNameSpace = SerializersUtil.addListNodeToUri((ListKey)key, curNameSpace, uriBuilder);
        } else {
            uriBuilder.append(SLASH);
            newNameSpace = SerializersUtil.addNodeNameToUri(key, curNameSpace, uriBuilder);
        }
        return newNameSpace;
    }

    private static String addLeafListNodeToUri(LeafListKey key, String curNameSpace, StringBuilder uriBuilder) {
        String newNameSpace = SerializersUtil.addNodeNameToUri((NodeKey)key, curNameSpace, uriBuilder);
        uriBuilder.append(EQUAL);
        uriBuilder.append(key.asString());
        return newNameSpace;
    }

    private static String addListNodeToUri(ListKey key, String curNameSpace, StringBuilder uriBuilder) {
        String newNameSpace = SerializersUtil.addNodeNameToUri((NodeKey)key, curNameSpace, uriBuilder);
        uriBuilder.append(EQUAL);
        String prefix = "";
        for (KeyLeaf keyLeaf : key.keyLeafs()) {
            uriBuilder.append(prefix);
            prefix = COMMA;
            uriBuilder.append(keyLeaf.leafValue().toString());
        }
        return newNameSpace;
    }

    private static String addNodeNameToUri(NodeKey key, String curNameSpace, StringBuilder uriBuilder) {
        String nodeName = key.schemaId().name();
        String newNameSpace = key.schemaId().namespace();
        uriBuilder.append(nodeName);
        if (newNameSpace == null) {
            return curNameSpace;
        }
        if (!newNameSpace.equals(curNameSpace)) {
            uriBuilder.append(COLON);
            uriBuilder.append(newNameSpace);
        }
        return newNameSpace;
    }
}

