/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fnl.impl;

import com.google.common.base.Preconditions;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.fnl.impl.DefaultCheckLoop;
import org.onosproject.fnl.intf.NetworkAnomaly;
import org.onosproject.fnl.intf.NetworkDiagnostic;
import org.onosproject.fnl.intf.NetworkDiagnosticService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class NetworkDiagnosticManager
implements NetworkDiagnosticService {
    public static final String NTS_APP_NAME = "org.onosproject.FNL.Network-Troubleshoot";
    private static final String PROPERTY_AUTO_REGISTER_DIAG = "autoRegisterDefaultDiagnostics";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService ds;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hs;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService frs;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService ls;
    @Property(name="autoRegisterDefaultDiagnostics", boolValue={true}, label="Automatically register all of default diagnostic modules.")
    private boolean autoRegister = true;
    private ApplicationId appId;
    private Map<NetworkDiagnostic.Type, NetworkDiagnostic> diagnostics = new ConcurrentHashMap<NetworkDiagnostic.Type, NetworkDiagnostic>();

    @Activate
    protected void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication(NTS_APP_NAME);
        this.cfgService.registerProperties(this.getClass());
        this.readConfiguration(context);
        this.autoRegisterDiagnostics();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterDiagnostics();
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        this.readConfiguration(context);
        this.log.info("Modified");
    }

    private void readConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean autoRegisterEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)PROPERTY_AUTO_REGISTER_DIAG);
        if (autoRegisterEnabled == null) {
            this.log.warn("Auto Register is not configured, using current value of {}", (Object)this.autoRegister);
        } else {
            this.autoRegister = autoRegisterEnabled;
            this.log.info("Configured. Auto Register is {}", (Object)(this.autoRegister ? "enabled" : "disabled"));
        }
    }

    private void autoRegisterDiagnostics() {
        if (!this.autoRegister) {
            return;
        }
        this.register(new DefaultCheckLoop(this.ds, this.hs, this.frs, this.ls));
    }

    private void unregisterDiagnostics() {
        this.diagnostics.clear();
    }

    public Set<NetworkAnomaly> findAnomalies() {
        HashSet<NetworkAnomaly> allAnomalies = new HashSet<NetworkAnomaly>();
        this.diagnostics.forEach((type, diag) -> allAnomalies.addAll(diag.findAnomalies()));
        return allAnomalies;
    }

    public Set<NetworkAnomaly> findAnomalies(NetworkDiagnostic.Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"NetworkAnomaly Type cannot be null");
        HashSet<NetworkAnomaly> anomalies = new HashSet<NetworkAnomaly>();
        NetworkDiagnostic diag = this.diagnostics.get(type);
        if (diag == null) {
            this.log.warn("no anomalies of type {} found", (Object)type);
            return anomalies;
        }
        anomalies.addAll(diag.findAnomalies());
        return anomalies;
    }

    public void register(NetworkDiagnostic diag) {
        Preconditions.checkNotNull((Object)diag, (Object)"Diagnostic cannot be null");
        NetworkDiagnostic oldDiag = this.diagnostics.put(diag.type(), diag);
        if (oldDiag != null) {
            this.log.warn("previous diagnostic {} is replaced by {},", oldDiag.getClass(), diag.getClass());
        } else {
            this.log.info("Register {} type module: {}", (Object)diag.type(), (Object)diag.getClass().getName());
        }
    }

    public boolean unregister(NetworkDiagnostic diag) {
        Preconditions.checkNotNull((Object)diag, (Object)"Diagnostic cannot be null");
        return this.diagnostics.remove(diag.type(), diag);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindDs(DeviceService deviceService) {
        this.ds = deviceService;
    }

    protected void unbindDs(DeviceService deviceService) {
        if (this.ds == deviceService) {
            this.ds = null;
        }
    }

    protected void bindHs(HostService hostService) {
        this.hs = hostService;
    }

    protected void unbindHs(HostService hostService) {
        if (this.hs == hostService) {
            this.hs = null;
        }
    }

    protected void bindFrs(FlowRuleService flowRuleService) {
        this.frs = flowRuleService;
    }

    protected void unbindFrs(FlowRuleService flowRuleService) {
        if (this.frs == flowRuleService) {
            this.frs = null;
        }
    }

    protected void bindLs(LinkService linkService) {
        this.ls = linkService;
    }

    protected void unbindLs(LinkService linkService) {
        if (this.ls == linkService) {
            this.ls = null;
        }
    }
}

