/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fnl.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.EthType;
import org.onlab.packet.IpPrefix;
import org.onosproject.fnl.base.NetworkDiagnosticUtils;
import org.onosproject.fnl.base.TsLoopPacket;
import org.onosproject.fnl.base.TsReturn;
import org.onosproject.fnl.intf.NetworkAnomaly;
import org.onosproject.fnl.intf.NetworkDiagnostic;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCheckLoop
implements NetworkDiagnostic {
    private static final int IP_PROTO_TCP_TS = 6;
    private static final int IP_PROTO_UDP_TS = 17;
    private static final String E_CANNOT_HANDLE = "can not handle {} now.";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeviceService deviceService;
    private final HostService hostService;
    private final FlowRuleService flowRuleService;
    private final LinkService linkService;
    private Map<DeviceId, Device> deviceInfo;
    private Map<DeviceId, Iterable<FlowEntry>> flowEntryInfo;
    private Set<Device> accessDevices;
    private Map<DeviceId, Set<Link>> egressLinkInfo;
    private Set<NetworkAnomaly> loops;
    private Set<DeviceId> excludeDeviceId;

    public DefaultCheckLoop(DeviceService ds, HostService hs, FlowRuleService frs, LinkService ls) {
        Preconditions.checkNotNull((Object)ds, (Object)"DeviceService cannot be null");
        Preconditions.checkNotNull((Object)hs, (Object)"HostService cannot be null");
        Preconditions.checkNotNull((Object)frs, (Object)"FlowRuleService cannot be null");
        Preconditions.checkNotNull((Object)ls, (Object)"LinkService  cannot be null");
        this.deviceService = ds;
        this.hostService = hs;
        this.flowRuleService = frs;
        this.linkService = ls;
    }

    public Set<NetworkAnomaly> findAnomalies() {
        return this.findLoop();
    }

    public NetworkDiagnostic.Type type() {
        return NetworkDiagnostic.Type.LOOP;
    }

    private Set<NetworkAnomaly> findLoop() {
        this.getNetworkSnapshot();
        this.loops = new HashSet<NetworkAnomaly>();
        this.excludeDeviceId = new HashSet<DeviceId>();
        for (Device device : this.accessDevices) {
            if (this.excludeDeviceId.contains(device.id())) continue;
            ArrayList availableFlowEntries = new ArrayList();
            this.flowEntryInfo.get(device.id()).forEach(flowEntry -> {
                if (flowEntry.state() == FlowEntry.FlowEntryState.ADDED) {
                    availableFlowEntries.add(flowEntry);
                }
            });
            List sortedFlowEntries = NetworkDiagnosticUtils.sortFlowTable(availableFlowEntries);
            for (FlowEntry flow : sortedFlowEntries) {
                TsLoopPacket pkt = TsLoopPacket.matchBuilder((Iterable)flow.selector().criteria(), null);
                pkt.pushPathFlow(flow);
                List inst = flow.treatment().immediate();
                for (Instruction instOne : inst) {
                    this.processOneInstruction(instOne, device.id(), null, pkt, true, flow);
                }
            }
        }
        return this.loops;
    }

    private boolean matchDeviceFlows(DeviceId deviceId, TsLoopPacket pkt) {
        if (pkt.isPassedDevice(deviceId)) {
            return true;
        }
        ArrayList availableFlowEntries = new ArrayList();
        this.flowEntryInfo.get(deviceId).forEach(flowEntry -> {
            if (flowEntry.state() == FlowEntry.FlowEntryState.ADDED) {
                availableFlowEntries.add(flowEntry);
            }
        });
        List sortedFlowEntries = NetworkDiagnosticUtils.sortFlowTable(availableFlowEntries);
        for (FlowEntry flowEntry2 : sortedFlowEntries) {
            TsReturn isBigger = new TsReturn();
            TsLoopPacket newPkt = pkt.copyPacketMatch();
            if (!this.matchAndAddFlowEntry(flowEntry2, newPkt, (TsReturn<Boolean>)isBigger)) continue;
            newPkt.pushPathFlow(flowEntry2);
            for (Instruction instOne : flowEntry2.treatment().immediate()) {
                if (!this.processOneInstruction(instOne, deviceId, pkt, newPkt, false, null)) continue;
                return true;
            }
            newPkt.popPathFlow();
            if (((Boolean)isBigger.getValue()).booleanValue()) continue;
            break;
        }
        return false;
    }

    private boolean processOneInstruction(Instruction instOne, DeviceId currentDeviceId, TsLoopPacket initPkt, TsLoopPacket matchedPkt, boolean isFindLoop, FlowEntry firstEntry) {
        if (isFindLoop) {
            Preconditions.checkArgument((initPkt == null ? 1 : 0) != 0, (Object)"initPkt is not null, while isFindLoop is true.");
        } else {
            Preconditions.checkArgument((firstEntry == null ? 1 : 0) != 0, (Object)"firstEntry is not null, while isFindLoop is false.");
        }
        Instruction.Type type = instOne.type();
        switch (type) {
            case L2MODIFICATION: {
                this.log.warn(E_CANNOT_HANDLE, (Object)type);
                break;
            }
            case L3MODIFICATION: {
                this.log.warn(E_CANNOT_HANDLE, (Object)type);
                break;
            }
            case L4MODIFICATION: {
                this.log.warn(E_CANNOT_HANDLE, (Object)type);
                break;
            }
            case OUTPUT: {
                if (!this.processOneOutputInstruction(instOne, currentDeviceId, initPkt, matchedPkt, isFindLoop, firstEntry)) break;
                return true;
            }
            default: {
                this.log.error("Can't process this type of instruction: {} now.", (Object)instOne.type());
            }
        }
        return false;
    }

    private boolean processOneOutputInstruction(Instruction instOne, DeviceId currentDeviceId, TsLoopPacket initPkt, TsLoopPacket matchedPkt, boolean isFindLoop, FlowEntry firstEntry) {
        Instructions.OutputInstruction instOutput = (Instructions.OutputInstruction)instOne;
        PortNumber instPort = instOutput.port();
        if (!instPort.isLogical()) {
            Set<Link> dstLink = this.tsGetEgressLinks(new ConnectPoint((ElementId)currentDeviceId, instPort));
            if (!dstLink.isEmpty()) {
                Link dstThisLink = dstLink.iterator().next();
                ConnectPoint dstPoint = dstThisLink.dst();
                if (NetworkDiagnosticUtils.isDevice((ConnectPoint)dstPoint)) {
                    PortCriterion oldInPort = this.updatePktInportPerHop(matchedPkt, dstPoint);
                    matchedPkt.pushPathLink(dstThisLink);
                    TsLoopPacket newNewPkt = matchedPkt.copyPacketMatch();
                    boolean loopFound = this.matchDeviceFlows(dstPoint.deviceId(), newNewPkt);
                    if (isFindLoop) {
                        if (loopFound) {
                            this.loops.add((NetworkAnomaly)newNewPkt);
                            this.updateExcludeDeviceSet(newNewPkt);
                        }
                        matchedPkt.resetLinkFlow(firstEntry);
                    } else {
                        if (loopFound) {
                            initPkt.handInLoopMatch(newNewPkt);
                            return true;
                        }
                        matchedPkt.popPathLink();
                    }
                    this.restorePktInportPerHop(matchedPkt, oldInPort);
                }
            } else if (!isFindLoop) {
                this.log.warn("no link connecting at device {}, port {}", (Object)currentDeviceId, (Object)instPort);
            }
        } else if (instPort.equals((Object)PortNumber.IN_PORT)) {
            this.log.warn("can not handle {} port now.", (Object)PortNumber.IN_PORT);
        } else if (instPort.equals((Object)PortNumber.NORMAL) || instPort.equals((Object)PortNumber.FLOOD) || instPort.equals((Object)PortNumber.ALL)) {
            this.log.warn("can not handle {}/{}/{} now.", new Object[]{PortNumber.NORMAL, PortNumber.FLOOD, PortNumber.ALL});
        }
        return false;
    }

    private void updateExcludeDeviceSet(TsLoopPacket loopPkt) {
        Iterator iter = loopPkt.getPathLink();
        while (iter.hasNext()) {
            this.excludeDeviceId.add(((Link)iter.next()).src().deviceId());
        }
    }

    private PortCriterion updatePktInportPerHop(TsLoopPacket oldPkt, ConnectPoint dstPoint) {
        PortCriterion inPort = oldPkt.getInport();
        PortCriterion oldInPort = null != inPort ? (PortCriterion)Criteria.matchInPort((PortNumber)inPort.port()) : null;
        oldPkt.setHeader(Criteria.matchInPort((PortNumber)dstPoint.port()));
        return oldInPort;
    }

    private void restorePktInportPerHop(TsLoopPacket pkt, PortCriterion oldInPort) {
        if (oldInPort == null) {
            pkt.delHeader(Criterion.Type.IN_PORT);
        } else {
            pkt.setHeader((Criterion)oldInPort);
        }
    }

    private void getNetworkSnapshot() {
        this.deviceInfo = new HashMap<DeviceId, Device>();
        this.deviceService.getDevices().forEach(d -> this.deviceInfo.put(d.id(), (Device)d));
        this.flowEntryInfo = new HashMap<DeviceId, Iterable<FlowEntry>>();
        this.deviceInfo.keySet().forEach(id -> this.flowEntryInfo.put((DeviceId)id, this.flowRuleService.getFlowEntries(id)));
        this.egressLinkInfo = new HashMap<DeviceId, Set<Link>>();
        this.deviceInfo.keySet().forEach(id -> this.egressLinkInfo.put((DeviceId)id, this.linkService.getDeviceEgressLinks(id)));
        this.accessDevices = new HashSet<Device>();
        this.hostService.getHosts().forEach(h -> this.accessDevices.add(this.deviceInfo.get(h.location().deviceId())));
    }

    private Set<Link> tsGetEgressLinks(ConnectPoint point) {
        HashSet<Link> portEgressLink = new HashSet<Link>();
        DeviceId deviceId = point.deviceId();
        portEgressLink.addAll(this.egressLinkInfo.get(deviceId).stream().filter(l -> l.src().equals((Object)point)).collect(Collectors.toList()));
        return portEgressLink;
    }

    private boolean matchAndAddFlowEntry(FlowEntry flowEntry, TsLoopPacket pkt, TsReturn<Boolean> isBigger) {
        isBigger.setValue((Object)false);
        List criterionArray = NetworkDiagnosticUtils.sortCriteria((Set)flowEntry.selector().criteria());
        block10: for (Criterion criterion : criterionArray) {
            switch (criterion.type()) {
                case IN_PORT: 
                case ETH_SRC: 
                case ETH_DST: 
                case ETH_TYPE: {
                    if (this.matchAddExactly(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
                case VLAN_VID: 
                case VLAN_PCP: {
                    if (!pkt.headerExists(Criterion.Type.ETH_TYPE) || !((EthTypeCriterion)pkt.getHeader(Criterion.Type.ETH_TYPE)).ethType().equals((Object)EthType.EtherType.VLAN.ethType())) {
                        return false;
                    }
                    if (this.matchAddExactly(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
                case IPV4_SRC: 
                case IPV4_DST: {
                    if (!pkt.headerExists(Criterion.Type.ETH_TYPE) || !((EthTypeCriterion)pkt.getHeader(Criterion.Type.ETH_TYPE)).ethType().equals((Object)EthType.EtherType.IPV4.ethType())) {
                        return false;
                    }
                    if (this.matchAddIPV4(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
                case IP_PROTO: {
                    if (!pkt.headerExists(Criterion.Type.ETH_TYPE) || !((EthTypeCriterion)pkt.getHeader(Criterion.Type.ETH_TYPE)).ethType().equals((Object)EthType.EtherType.IPV4.ethType())) {
                        return false;
                    }
                    if (this.matchAddExactly(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
                case IP_DSCP: {
                    continue block10;
                }
                case IP_ECN: {
                    continue block10;
                }
                case TCP_SRC: 
                case TCP_DST: {
                    if (!pkt.headerExists(Criterion.Type.IP_PROTO) || 6 != ((IPProtocolCriterion)pkt.getHeader(Criterion.Type.IP_PROTO)).protocol()) {
                        return false;
                    }
                    if (this.matchAddExactly(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
                case UDP_SRC: 
                case UDP_DST: {
                    if (!pkt.headerExists(Criterion.Type.IP_PROTO) || 17 != ((IPProtocolCriterion)pkt.getHeader(Criterion.Type.IP_PROTO)).protocol()) {
                        return false;
                    }
                    if (this.matchAddExactly(pkt, criterion, isBigger)) continue block10;
                    return false;
                }
            }
            this.log.debug("{} can't be supported by OF1.0", (Object)criterion.type());
            return false;
        }
        return true;
    }

    private boolean matchAddExactly(TsLoopPacket pkt, Criterion criterion, TsReturn<Boolean> isBigger) {
        if (pkt.headerExists(criterion.type())) {
            if (!pkt.getHeader(criterion.type()).equals(criterion)) {
                return false;
            }
        } else {
            pkt.setHeader(criterion);
            isBigger.setValue((Object)true);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchAddIPV4(TsLoopPacket pkt, Criterion criterion, TsReturn<Boolean> isBigger) {
        if (pkt.headerExists(criterion.type())) {
            IpPrefix ipPkt;
            IpPrefix ipFlow = ((IPCriterion)criterion).ip();
            if (ipFlow.equals((Object)(ipPkt = ((IPCriterion)pkt.getHeader(criterion.type())).ip())) || ipFlow.contains(ipPkt)) return true;
            if (!ipPkt.contains(ipFlow)) return false;
            pkt.setHeader(criterion);
            isBigger.setValue((Object)true);
            return true;
        } else {
            pkt.setHeader(criterion);
            isBigger.setValue((Object)true);
        }
        return true;
    }
}

