/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.topology;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.onlab.util.Bandwidth;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLinkInformation;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLinkTed;
import org.onosproject.isis.controller.impl.topology.DefaultIsisRouter;
import org.onosproject.isis.controller.topology.DeviceInformation;
import org.onosproject.isis.controller.topology.IsisLinkTed;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.controller.topology.LinkInformation;
import org.onosproject.isis.controller.topology.TopologyForDeviceAndLink;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.tlv.IsExtendedReachability;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.NeighborForExtendedIs;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.InterfaceIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.NeighborIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;
import org.onosproject.isis.io.util.IsisConstants;
import org.onosproject.isis.io.util.IsisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyForDeviceAndLinkImpl
implements TopologyForDeviceAndLink {
    private static final Logger log = LoggerFactory.getLogger(TopologyForDeviceAndLinkImpl.class);
    private Map<String, DeviceInformation> deviceInformationMap = new LinkedHashMap<String, DeviceInformation>();
    private Map<String, IsisRouter> isisRouterDetails = new LinkedHashMap<String, IsisRouter>();
    private Map<String, DeviceInformation> deviceInformationMapForPointToPoint = new LinkedHashMap<String, DeviceInformation>();
    private Map<String, DeviceInformation> deviceInformationMapToDelete = new LinkedHashMap<String, DeviceInformation>();
    private Map<String, LinkInformation> addedLinkInformationMap = new LinkedHashMap<String, LinkInformation>();

    public Map<String, DeviceInformation> deviceInformationMap() {
        return this.deviceInformationMap;
    }

    public Map<String, IsisRouter> isisDeviceList() {
        return this.isisRouterDetails;
    }

    public void setDeviceInformationMap(String key, DeviceInformation deviceInformationMap) {
        if (deviceInformationMap != null) {
            this.deviceInformationMap.put(key, deviceInformationMap);
        }
    }

    public Map<String, DeviceInformation> deviceInformationMapForPointToPoint() {
        return this.deviceInformationMapForPointToPoint;
    }

    public void setDeviceInformationMapForPointToPoint(String key, DeviceInformation deviceInformationMap) {
        if (deviceInformationMap != null) {
            this.deviceInformationMapForPointToPoint.put(key, deviceInformationMap);
        }
    }

    public Map<String, DeviceInformation> deviceInformationMapToDelete() {
        return this.deviceInformationMapToDelete;
    }

    public void setDeviceInformationMapToDelete(String key, DeviceInformation deviceInformationMapToDelete) {
        if (deviceInformationMapToDelete != null) {
            this.deviceInformationMapToDelete.put(key, deviceInformationMapToDelete);
        }
    }

    public void removeDeviceInformationMapFromDeleteMap(String key) {
        this.removeDeviceInformationMap(key);
        if (this.deviceInformationMapToDelete.containsKey(key)) {
            this.deviceInformationMapToDelete.remove(key);
        }
    }

    public DeviceInformation deviceInformation(String key) {
        DeviceInformation deviceInformation = this.deviceInformationMap.get(key);
        return deviceInformation;
    }

    public void removeDeviceInformationMap(String key) {
        if (this.deviceInformationMap.containsKey(key)) {
            this.deviceInformationMap.remove(key);
        }
    }

    public void removeLinks(String linkId) {
        this.addedLinkInformationMap.remove(linkId);
    }

    public Map<String, LinkInformation> linkInformationMap() {
        return this.addedLinkInformationMap;
    }

    private LinkInformation getLinkInformation(String key) {
        LinkInformation linkInformation = this.addedLinkInformationMap.get(key);
        return linkInformation;
    }

    public void setLinkInformationMap(String key, LinkInformation linkInformationMap) {
        if (!this.addedLinkInformationMap.containsKey(key)) {
            this.addedLinkInformationMap.put(key, linkInformationMap);
        }
    }

    public Map<String, LinkInformation> linkInformationMapForPointToPoint() {
        return this.addedLinkInformationMap;
    }

    public void setLinkInformationMapForPointToPoint(String key, LinkInformation linkInformationMap) {
        if (!this.addedLinkInformationMap.containsKey(key)) {
            this.addedLinkInformationMap.put(key, linkInformationMap);
        }
    }

    public void removeLinkInformationMap(String key) {
        if (this.addedLinkInformationMap.containsKey(key)) {
            this.addedLinkInformationMap.remove(key);
        }
    }

    public IsisRouter isisRouter(String systemId) {
        String routerId = IsisUtil.removeTailingZeros((String)systemId);
        IsisRouter isisRouter = this.isisRouterDetails.get(routerId);
        if (isisRouter != null) {
            return isisRouter;
        }
        log.debug("IsisRouter is not available");
        DefaultIsisRouter isisRouterCheck = new DefaultIsisRouter();
        isisRouterCheck.setSystemId(routerId);
        return isisRouterCheck;
    }

    public void removeRouter(String systemId) {
        String routerId = IsisUtil.removeTailingZeros((String)systemId);
        this.isisRouterDetails.remove(systemId);
    }

    public IsisRouter createDeviceInfo(LsPdu lsPdu) {
        IsisRouter isisRouter = this.createIsisRouter(lsPdu);
        if (isisRouter.systemId() != null && isisRouter.interfaceId() == null && isisRouter.neighborRouterId() == null) {
            isisRouter.setInterfaceId(IsisConstants.DEFAULTIP);
            isisRouter.setNeighborRouterId(IsisConstants.DEFAULTIP);
            this.isisRouterDetails.put(isisRouter.systemId(), isisRouter);
        }
        return isisRouter;
    }

    public Map<String, LinkInformation> createLinkInfo(LsPdu lsPdu, String ownSystemId) {
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighborForExtendedIsList = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs neighbor : neighborForExtendedIsList) {
                String linkId;
                String neighbourId = neighbor.neighborId();
                String routerId = IsisUtil.removeTailingZeros((String)lsPdu.lspId());
                if (neighbourId.equals(ownSystemId)) continue;
                IsisRouter isisRouter = this.isisRouterDetails.get(neighbourId);
                if (isisRouter != null) {
                    linkId = "link:" + routerId + "-" + neighbourId;
                    this.addedLinkInformationMap.put(linkId, this.createLinkInformation(lsPdu, linkId, routerId, neighbourId));
                    continue;
                }
                this.createIsisRouterDummy(neighbourId);
                linkId = "link:" + routerId + "-" + neighbourId;
                LinkInformation linkInformation = this.createLinkInformation(lsPdu, linkId, routerId, neighbourId);
                linkInformation.setAlreadyCreated(true);
                this.addedLinkInformationMap.put(linkId, linkInformation);
            }
        }
        return this.addedLinkInformationMap;
    }

    public Map<String, LinkInformation> removeLinkInfo(String systemId) {
        String routerId = IsisUtil.removeTailingZeros((String)systemId);
        LinkedHashMap<String, LinkInformation> removeLinkInformationMap = new LinkedHashMap<String, LinkInformation>();
        for (String key : this.addedLinkInformationMap.keySet()) {
            if (!key.contains(routerId)) continue;
            removeLinkInformationMap.put(key, this.addedLinkInformationMap.get(key));
        }
        return removeLinkInformationMap;
    }

    private LinkInformation createLinkInformation(LsPdu lsPdu, String linkId, String localRouter, String neighborId) {
        DefaultIsisLinkInformation linkInformation = new DefaultIsisLinkInformation();
        IsisRouter isisRouter = this.isisRouterDetails.get(neighborId);
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                List teSubTlvs = teTlv.teSubTlv();
                for (TrafficEngineeringSubTlv teSubTlv : teSubTlvs) {
                    if (teSubTlv instanceof InterfaceIpAddress) {
                        InterfaceIpAddress localIpAddress = (InterfaceIpAddress)teSubTlv;
                        linkInformation.setInterfaceIp(localIpAddress.localInterfaceIPAddress());
                        continue;
                    }
                    if (!(teSubTlv instanceof NeighborIpAddress)) continue;
                    NeighborIpAddress neighborIpAddress = (NeighborIpAddress)teSubTlv;
                    linkInformation.setNeighborIp(neighborIpAddress.neighborIPAddress());
                }
            }
        }
        linkInformation.setLinkId(linkId);
        linkInformation.setAlreadyCreated(false);
        linkInformation.setLinkDestinationId(neighborId);
        linkInformation.setLinkSourceId(localRouter);
        return linkInformation;
    }

    private IsisRouter createIsisRouter(LsPdu lsPdu) {
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        if (IsisUtil.checkIsDis((String)lsPdu.lspId())) {
            isisRouter.setDis(true);
        } else {
            isisRouter.setDis(false);
        }
        isisRouter.setSystemId(IsisUtil.removeTailingZeros((String)lsPdu.lspId()));
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                List teSubTlvs = teTlv.teSubTlv();
                for (TrafficEngineeringSubTlv teSubTlv : teSubTlvs) {
                    if (teSubTlv instanceof InterfaceIpAddress) {
                        InterfaceIpAddress localIpAddress = (InterfaceIpAddress)teSubTlv;
                        isisRouter.setInterfaceId(localIpAddress.localInterfaceIPAddress());
                        continue;
                    }
                    if (!(teSubTlv instanceof NeighborIpAddress)) continue;
                    NeighborIpAddress neighborIpAddress = (NeighborIpAddress)teSubTlv;
                    isisRouter.setNeighborRouterId(neighborIpAddress.neighborIPAddress());
                }
            }
        }
        return isisRouter;
    }

    private IsisRouter createIsisRouterDummy(String systemId) {
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        isisRouter.setSystemId(systemId);
        isisRouter.setDis(false);
        isisRouter.setInterfaceId(IsisConstants.DEFAULTIP);
        isisRouter.setNeighborRouterId(IsisConstants.DEFAULTIP);
        return isisRouter;
    }

    public IsisLinkTed createIsisLinkTedInfo(LsPdu lsPdu) {
        DefaultIsisLinkTed isisLinkTed = new DefaultIsisLinkTed();
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                List teSubTlvs = teTlv.teSubTlv();
                for (TrafficEngineeringSubTlv teSubTlv : teSubTlvs) {
                    if (teSubTlv instanceof AdministrativeGroup) {
                        AdministrativeGroup ag = (AdministrativeGroup)teSubTlv;
                        isisLinkTed.setAdministrativeGroup(ag.administrativeGroup());
                    }
                    if (teSubTlv instanceof InterfaceIpAddress) {
                        InterfaceIpAddress localIpAddress = (InterfaceIpAddress)teSubTlv;
                        isisLinkTed.setIpv4InterfaceAddress(localIpAddress.localInterfaceIPAddress());
                    }
                    if (teSubTlv instanceof NeighborIpAddress) {
                        NeighborIpAddress neighborIpAddress = (NeighborIpAddress)teSubTlv;
                        isisLinkTed.setIpv4NeighborAddress(neighborIpAddress.neighborIPAddress());
                    }
                    if (teSubTlv instanceof TrafficEngineeringMetric) {
                        TrafficEngineeringMetric teM = (TrafficEngineeringMetric)teSubTlv;
                        isisLinkTed.setTeDefaultMetric(teM.getTrafficEngineeringMetricValue());
                    }
                    if (teSubTlv instanceof MaximumBandwidth) {
                        MaximumBandwidth maxLinkBandwidth = (MaximumBandwidth)teSubTlv;
                        isisLinkTed.setMaximumLinkBandwidth(Bandwidth.bps((double)maxLinkBandwidth.getMaximumBandwidthValue()));
                    }
                    if (teSubTlv instanceof MaximumReservableBandwidth) {
                        MaximumReservableBandwidth maxReservableBw = (MaximumReservableBandwidth)teSubTlv;
                        isisLinkTed.setMaximumReservableLinkBandwidth(Bandwidth.bps((double)maxReservableBw.getMaximumBandwidthValue()));
                    }
                    if (!(teSubTlv instanceof UnreservedBandwidth)) continue;
                    UnreservedBandwidth unReservedBandwidth = (UnreservedBandwidth)teSubTlv;
                    ArrayList<Bandwidth> bandwidthList = new ArrayList<Bandwidth>();
                    List unReservedBandwidthList = unReservedBandwidth.unReservedBandwidthValue();
                    for (Float unReservedBandwidthFloatValue : unReservedBandwidthList) {
                        Bandwidth bandwidth = Bandwidth.bps((double)unReservedBandwidthFloatValue.floatValue());
                        bandwidthList.add(bandwidth);
                    }
                    isisLinkTed.setUnreservedBandwidth(bandwidthList);
                }
            }
        }
        return isisLinkTed;
    }
}

