/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import java.util.concurrent.BlockingQueue;
import org.jboss.netty.channel.Channel;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.util.IsisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisLspQueueConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IsisLspQueueConsumer.class);
    private BlockingQueue queue = null;

    public IsisLspQueueConsumer(BlockingQueue queue) {
        this.queue = queue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        log.debug("LSPQueueConsumer:run...!!!");
        try {
            block10: while (true) {
                String lspProcessing;
                if (this.queue.isEmpty()) {
                    continue;
                }
                LspWrapper wrapper = (LspWrapper)this.queue.take();
                switch (lspProcessing = wrapper.lspProcessing()) {
                    case "refreshLsp": {
                        log.debug("LSPQueueConsumer: Message - refreshLsp consumed.");
                        this.processRefreshLsp(wrapper);
                        continue block10;
                    }
                    case "maxAgeLsp": {
                        log.debug("LSPQueueConsumer: Message - maxAgeLsp consumed.");
                        this.processMaxAgeLsa(wrapper);
                        continue block10;
                    }
                }
                log.debug("Unknown command to process the LSP in queue ...!!!");
            }
        }
        catch (Exception e) {
            log.debug("Error::LSPQueueConsumer::{}", (Object)e.getMessage());
            return;
        }
    }

    private void processRefreshLsp(LspWrapper wrapper) throws Exception {
        DefaultIsisInterface isisInterface;
        Channel channel;
        if (wrapper.isSelfOriginated() && (channel = (isisInterface = (DefaultIsisInterface)wrapper.isisInterface()).channel()) != null && channel.isConnected()) {
            LsPdu lsPdu = (LsPdu)wrapper.lsPdu();
            lsPdu.setSequenceNumber(isisInterface.isisLsdb().lsSequenceNumber(IsisPduType.get((int)lsPdu.pduType())));
            lsPdu.setRemainingLifeTime(1200);
            byte[] lspBytes = lsPdu.asBytes();
            lspBytes = IsisUtil.addLengthAndMarkItInReserved((byte[])lspBytes, (int)8, (int)9, (int)6);
            lspBytes = IsisUtil.addChecksum((byte[])lspBytes, (int)24, (int)25);
            channel.write((Object)IsisUtil.framePacket((byte[])lspBytes, (int)isisInterface.interfaceIndex()));
            IsisLsdb isisDb = isisInterface.isisLsdb();
            isisDb.addLsp((IsisMessage)lsPdu, true, (IsisInterface)isisInterface);
            log.debug("LSPQueueConsumer: processRefreshLsp - Flooded SelfOriginated LSP {}", (Object)wrapper.lsPdu());
        }
    }

    private void processMaxAgeLsa(LspWrapper wrapper) {
        DefaultIsisInterface isisInterface = (DefaultIsisInterface)wrapper.isisInterface();
        if (isisInterface != null) {
            LsPdu lsPdu = (LsPdu)wrapper.lsPdu();
            IsisLsdb isisDb = isisInterface.isisLsdb();
            isisDb.deleteLsp((IsisMessage)lsPdu);
            log.debug("LSPQueueConsumer: processMaxAgeLsp - Removed-Max Age LSP {}", (Object)wrapper.lsPdu());
        }
    }
}

