/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.isis.controller.IsisLspBin;
import org.onosproject.isis.controller.LspWrapper;

public class DefaultIsisLspBin
implements IsisLspBin {
    private int binNumber;
    private Map<String, LspWrapper> listOfLsp = new ConcurrentHashMap<String, LspWrapper>();

    public DefaultIsisLspBin(int binNumber) {
        this.binNumber = binNumber;
    }

    public void addIsisLsp(String lspKey, LspWrapper lspWrapper) {
        if (!this.listOfLsp.containsKey(lspKey)) {
            this.listOfLsp.put(lspKey, lspWrapper);
            lspWrapper.setBinNumber(this.binNumber);
        }
    }

    public LspWrapper isisLsp(String lspKey) {
        return this.listOfLsp.get(lspKey);
    }

    public void removeIsisLsp(String lspKey, LspWrapper lspWrapper) {
        if (this.listOfLsp.containsKey(lspKey)) {
            this.listOfLsp.remove(lspKey);
        }
    }

    public Map<String, LspWrapper> listOfLsp() {
        return this.listOfLsp;
    }

    public int binNumber() {
        return this.binNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("binNumber", this.binNumber).add("listOfLsp", this.listOfLsp).toString();
    }
}

