/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onosproject.isis.controller.IsisLsdbAge;
import org.onosproject.isis.controller.IsisLspBin;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLspBin;
import org.onosproject.isis.controller.impl.lsdb.IsisLspQueueConsumer;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIsisLsdbAge
implements IsisLsdbAge {
    private static final Logger log = LoggerFactory.getLogger(DefaultIsisLsdbAge.class);
    protected int ageCounter = 0;
    private InternalAgeTimer dbAgeTimer;
    private ScheduledExecutorService exServiceage;
    private Integer maxBins = 1200;
    private Map<Integer, IsisLspBin> ageBins = new ConcurrentHashMap<Integer, IsisLspBin>(this.maxBins);
    private int ageCounterRollOver = 0;
    private IsisLspQueueConsumer queueConsumer = null;
    private BlockingQueue<LspWrapper> lsaQueue = new ArrayBlockingQueue<LspWrapper>(1024);
    private boolean timerStarted = false;

    public DefaultIsisLsdbAge() {
        for (int i = 0; i < this.maxBins; ++i) {
            DefaultIsisLspBin lspBin = new DefaultIsisLspBin(i);
            this.ageBins.put(i, lspBin);
        }
    }

    public int ageCounter() {
        return this.ageCounter;
    }

    public int ageCounterRollOver() {
        return this.ageCounterRollOver;
    }

    public void addLspBin(int binNumber, IsisLspBin lspBin) {
        if (!this.ageBins.containsKey(binNumber)) {
            this.ageBins.put(binNumber, lspBin);
        }
    }

    public IsisLspBin getLspBin(int binKey) {
        return this.ageBins.get(binKey);
    }

    public void removeLspFromBin(LspWrapper lspWrapper) {
        if (this.ageBins.containsKey(lspWrapper.binNumber())) {
            IsisLspBin lsaBin = this.ageBins.get(lspWrapper.binNumber());
            lsaBin.removeIsisLsp(((LsPdu)lspWrapper.lsPdu()).lspId(), lspWrapper);
        }
    }

    public int age2Bin(int age) {
        if (age <= this.ageCounter) {
            return this.ageCounter - age;
        }
        return 1199 + (this.ageCounter - age);
    }

    public void startDbAging() {
        if (!this.timerStarted) {
            this.startDbAgeTimer();
            this.queueConsumer = new IsisLspQueueConsumer(this.lsaQueue);
            new Thread(this.queueConsumer).start();
            this.timerStarted = true;
        }
    }

    private void startDbAgeTimer() {
        this.dbAgeTimer = new InternalAgeTimer();
        this.exServiceage = Executors.newSingleThreadScheduledExecutor();
        this.exServiceage.scheduleAtFixedRate(this.dbAgeTimer, 1L, 1L, TimeUnit.SECONDS);
    }

    public void ageLsp() {
        this.refreshLsa();
        this.maxAgeLsa();
        if (this.ageCounter == 1200) {
            this.ageCounter = 0;
            ++this.ageCounterRollOver;
        } else {
            ++this.ageCounter;
        }
    }

    public void maxAgeLsa() {
        if (this.ageCounter == 0) {
            return;
        }
        IsisLspBin lspBin = this.ageBins.get(this.ageCounter - 1);
        if (lspBin == null) {
            return;
        }
        Map lspBinMap = lspBin.listOfLsp();
        for (Object key : lspBinMap.keySet()) {
            LspWrapper lspWrapper = (LspWrapper)lspBinMap.get((String)key);
            if (lspWrapper.currentAge() != 1200) continue;
            lspWrapper.setLspProcessing("maxAgeLsp");
            log.debug("Lsp picked for maxage removal. Age Counter: {}, AgeCounterRollover: {}, AgeCounterRollover WhenAddedToDb: {}, LSA Type: {}, LSA Key: {}", new Object[]{this.ageCounter, this.ageCounterRollOver, lspWrapper.currentAge(), lspWrapper.lsPdu().isisPduType(), key});
            try {
                this.lsaQueue.put(lspWrapper);
                lspBin.removeIsisLsp((String)key, lspWrapper);
            }
            catch (InterruptedException e) {
                log.debug("Error::LSDBAge::maxAgeLsp::{}", (Object)e.getMessage());
            }
        }
    }

    public void refreshLsa() {
        IsisLspBin lspBin;
        int binNumber = this.ageCounter < 900 ? this.ageCounter + 900 : this.ageCounter - 900;
        if (binNumber >= 1200) {
            binNumber -= 1200;
        }
        if ((lspBin = this.ageBins.get(binNumber)) == null) {
            return;
        }
        Map lspBinMap = lspBin.listOfLsp();
        for (Object key : lspBinMap.keySet()) {
            LspWrapper lsp = (LspWrapper)lspBinMap.get((String)key);
            try {
                if (!lsp.isSelfOriginated()) continue;
                log.debug("Lsp picked for refreshLsp. binNumber: {}, LSA Type: {}, LSA Key: {}", new Object[]{binNumber, lsp.lspType(), key});
                lsp.setLspProcessing("refreshLsp");
                this.lsaQueue.put(lsp);
                lspBin.removeIsisLsp((String)key, lsp);
            }
            catch (InterruptedException e) {
                log.debug("Error::LSDBAge::refreshLsp::{}", (Object)e.getMessage());
            }
        }
    }

    private class InternalAgeTimer
    implements Runnable {
        InternalAgeTimer() {
            log.debug("Starts::IsisLsdbAge::AgeTimer...!!! ");
        }

        @Override
        public void run() {
            DefaultIsisLsdbAge.this.ageLsp();
        }
    }
}

