/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.io.isispacket.IsisMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisMessageDecoder
extends FrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(IsisMessageDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        log.debug("IsisMessageDecoder::Message received <:> length {}", (Object)buffer.readableBytes());
        if (!channel.isConnected()) {
            log.info("Channel is not connected.");
            return null;
        }
        IsisMessageReader messageReader = new IsisMessageReader();
        LinkedList<IsisMessage> isisMessageList = new LinkedList<IsisMessage>();
        int dataLength = buffer.readableBytes();
        while (buffer.readableBytes() >= 1521) {
            ChannelBuffer payload = buffer.readBytes(1521);
            ChannelBuffer ethernetHeader = payload.readBytes(17);
            MacAddress sourceMac = this.getSourceMac(ethernetHeader);
            ChannelBuffer isisDataBuffer = payload.readBytes(payload.readableBytes());
            int readableBytes = isisDataBuffer.readableBytes();
            IsisMessage message = messageReader.readFromBuffer(isisDataBuffer);
            if (message == null) continue;
            if (isisDataBuffer.readableBytes() >= 7) {
                message.setSourceMac(sourceMac);
                isisDataBuffer.readerIndex(readableBytes - 7);
                log.debug("IsisMessageDecoder::Reading metadata <:> length {}", (Object)isisDataBuffer.readableBytes());
                byte[] macBytes = new byte[6];
                isisDataBuffer.readBytes(macBytes, 0, 6);
                MacAddress macAddress = MacAddress.valueOf((byte[])macBytes);
                byte interfaceIndex = isisDataBuffer.readByte();
                message.setInterfaceMac(macAddress);
                message.setInterfaceIndex((int)interfaceIndex);
            }
            isisMessageList.add(message);
        }
        return !isisMessageList.isEmpty() ? isisMessageList : null;
    }

    private MacAddress getSourceMac(ChannelBuffer ethHeader) {
        ethHeader.skipBytes(6);
        MacAddress sourceMac = MacAddress.valueOf((byte[])ethHeader.readBytes(6).array());
        return sourceMac;
    }
}

