/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdb;
import org.onosproject.isis.exceptions.IsisParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisChannelHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(IsisChannelHandler.class);
    private static Map<Integer, Object> isisDb = null;
    private Channel channel = null;
    private Controller controller;
    private List<IsisProcess> processes = null;
    private List<ScheduledExecutorService> executorList = new ArrayList<ScheduledExecutorService>();
    private byte[] configPacket = null;
    private Map<Integer, IsisInterface> isisInterfaceMap = new ConcurrentHashMap<Integer, IsisInterface>();
    private IsisLsdb isisLsdb = new DefaultIsisLsdb();
    private List<Ip4Address> interfaceIps = new ArrayList<Ip4Address>();

    public IsisChannelHandler(Controller controller, List<IsisProcess> processes) {
        this.controller = controller;
        this.processes = processes;
        ((DefaultIsisLsdb)this.isisLsdb).setController(this.controller);
        ((DefaultIsisLsdb)this.isisLsdb).setIsisInterface(this.isisInterfaceList());
    }

    private List<IsisInterface> isisInterfaceList() {
        ArrayList<IsisInterface> isisInterfaceList = new ArrayList<IsisInterface>();
        for (Integer key : this.isisInterfaceMap.keySet()) {
            isisInterfaceList.add(this.isisInterfaceMap.get(key));
        }
        return isisInterfaceList;
    }

    public void initializeInterfaceMap() {
        for (IsisProcess process : this.processes) {
            for (IsisInterface isisInterface : process.isisInterfaceList()) {
                IsisInterface anInterface = this.isisInterfaceMap.get(isisInterface.interfaceIndex());
                if (anInterface != null) continue;
                this.isisInterfaceMap.put(isisInterface.interfaceIndex(), isisInterface);
                this.interfaceIps.add(isisInterface.interfaceIpAddress());
            }
        }
        this.initializeInterfaceIpList();
    }

    public void updateInterfaceMap(List<IsisProcess> isisProcesses) {
        for (IsisProcess isisUpdatedProcess : isisProcesses) {
            for (IsisInterface isisUpdatedInterface : isisUpdatedProcess.isisInterfaceList()) {
                IsisInterface isisInterface = this.isisInterfaceMap.get(isisUpdatedInterface.interfaceIndex());
                if (isisInterface == null) {
                    this.isisInterfaceMap.put(isisUpdatedInterface.interfaceIndex(), isisUpdatedInterface);
                    this.interfaceIps.add(isisUpdatedInterface.interfaceIpAddress());
                    continue;
                }
                if (!isisInterface.intermediateSystemName().equals(isisUpdatedInterface.intermediateSystemName())) {
                    isisInterface.setIntermediateSystemName(isisUpdatedInterface.intermediateSystemName());
                }
                if (isisInterface.reservedPacketCircuitType() != isisUpdatedInterface.reservedPacketCircuitType()) {
                    isisInterface.setReservedPacketCircuitType(isisUpdatedInterface.reservedPacketCircuitType());
                    isisInterface.removeNeighbors();
                }
                if (!isisInterface.circuitId().equals(isisUpdatedInterface.circuitId())) {
                    isisInterface.setCircuitId(isisUpdatedInterface.circuitId());
                }
                if (isisInterface.networkType() != isisUpdatedInterface.networkType()) {
                    isisInterface.setNetworkType(isisUpdatedInterface.networkType());
                    isisInterface.removeNeighbors();
                }
                if (!isisInterface.areaAddress().equals(isisUpdatedInterface.areaAddress())) {
                    isisInterface.setAreaAddress(isisUpdatedInterface.areaAddress());
                }
                if (isisInterface.holdingTime() != isisUpdatedInterface.holdingTime()) {
                    isisInterface.setHoldingTime(isisUpdatedInterface.holdingTime());
                }
                if (isisInterface.helloInterval() != isisUpdatedInterface.helloInterval()) {
                    isisInterface.setHelloInterval(isisUpdatedInterface.helloInterval());
                    isisInterface.stopHelloSender();
                    isisInterface.startHelloSender(this.channel);
                }
                this.isisInterfaceMap.put(isisInterface.interfaceIndex(), isisInterface);
            }
        }
    }

    public void initializeInterfaceIpList() {
        for (IsisProcess process : this.processes) {
            for (IsisInterface isisInterface : process.isisInterfaceList()) {
                ((DefaultIsisInterface)isisInterface).setAllConfiguredInterfaceIps(this.interfaceIps);
            }
        }
    }

    private void initialize() {
        log.debug("IsisChannelHandler initialize..!!!");
        if (this.configPacket != null) {
            log.debug("IsisChannelHandler initialize -> sentConfig packet of length ::" + this.configPacket.length);
            this.sentConfigPacket(this.configPacket);
        }
        this.initializeInterfaceMap();
        this.startHelloSender();
        this.isisLsdb.initializeDb();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
        log.info("ISIS channelConnected from {}", (Object)evt.getChannel().getRemoteAddress());
        this.channel = evt.getChannel();
        this.initialize();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent evt) {
        log.debug("IsisChannelHandler::channelDisconnected...!!!");
        if (this.controller != null) {
            this.controller.connectPeer();
            this.stopHelloSender();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ReadTimeoutException) {
            log.debug("Disconnecting device {} due to read timeout", (Object)e.getChannel().getRemoteAddress());
            return;
        }
        if (e.getCause() instanceof ClosedChannelException) {
            log.debug("Channel for ISIS {} already closed", (Object)e.getChannel().getRemoteAddress());
        } else if (e.getCause() instanceof IOException) {
            log.debug("Disconnecting ISIS {} due to IO Error: {}", (Object)e.getChannel().getRemoteAddress(), (Object)e.getCause().getMessage());
        } else if (e.getCause() instanceof IsisParseException) {
            IsisParseException errMsg = (IsisParseException)e.getCause();
            byte errorCode = errMsg.errorCode();
            byte errorSubCode = errMsg.errorSubCode();
            log.debug("Error while parsing message from ISIS {}, ErrorCode {}", (Object)e.getChannel().getRemoteAddress(), (Object)errorCode);
        } else if (e.getCause() instanceof RejectedExecutionException) {
            log.debug("Could not process message: queue full");
        } else {
            log.debug("Error while processing message from ISIS {}, {}", (Object)e.getChannel().getRemoteAddress(), (Object)e.getCause().getMessage());
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        log.debug("IsisChannelHandler::messageReceived...!!!");
        Object message = e.getMessage();
        if (message instanceof List) {
            List isisMessageList = (List)message;
            log.debug("IsisChannelHandler::List of IsisMessages Size {}", (Object)isisMessageList.size());
            if (isisMessageList != null) {
                for (IsisMessage isisMessage : isisMessageList) {
                    this.processIsisMessage(isisMessage, ctx);
                }
            } else {
                log.debug("IsisChannelHandler::IsisMessages Null List...!!");
            }
        }
        if (message instanceof IsisMessage) {
            IsisMessage isisMessage = (IsisMessage)message;
            log.debug("IsisChannelHandler::IsisMessages received...!!");
            this.processIsisMessage(isisMessage, ctx);
        }
    }

    public void processIsisMessage(IsisMessage isisMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("IsisChannelHandler::processIsisMessage...!!!");
        int interfaceIndex = isisMessage.interfaceIndex();
        IsisInterface isisInterface = this.isisInterfaceMap.get(interfaceIndex);
        isisInterface.processIsisMessage(isisMessage, this.isisLsdb, this.channel);
    }

    public void startHelloSender() {
        log.debug("IsisController::startHelloSender");
        Set<Integer> interfaceIndexes = this.isisInterfaceMap.keySet();
        for (Integer interfaceIndex : interfaceIndexes) {
            IsisInterface isisInterface = this.isisInterfaceMap.get(interfaceIndex);
            isisInterface.startHelloSender(this.channel);
        }
    }

    public void stopHelloSender() {
        log.debug("ISISChannelHandler::stopHelloTimer ");
        log.debug("IsisController::startHelloSender");
        Set<Integer> interfaceIndexes = this.isisInterfaceMap.keySet();
        for (Integer interfaceIndex : interfaceIndexes) {
            IsisInterface isisInterface = this.isisInterfaceMap.get(interfaceIndex);
            isisInterface.stopHelloSender();
        }
    }

    public void sentConfigPacket(byte[] configPacket) {
        if (this.channel != null && this.channel.isConnected() && this.channel.isOpen()) {
            this.channel.write((Object)configPacket);
            log.debug("IsisChannelHandler sentConfigPacket packet sent..!!!");
        } else {
            log.debug("IsisChannelHandler sentConfigPacket channel not connected - re try..!!!");
            this.configPacket = configPacket;
        }
    }
}

