/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictor;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.util.Tools;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.DefaultIsisProcess;
import org.onosproject.isis.controller.impl.IsisChannelHandler;
import org.onosproject.isis.controller.impl.IsisPipelineFactory;
import org.onosproject.isis.controller.topology.IsisAgent;
import org.onosproject.isis.controller.topology.IsisLink;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.io.util.IsisConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    protected static final int BUFFER_SIZE = 0x400000;
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final int RETRY_INTERVAL = 4;
    private final int peerWorkerThreads = 16;
    byte[] configPacket = null;
    private List<IsisProcess> processes = null;
    private IsisChannelHandler isisChannelHandler;
    private NioClientSocketChannelFactory peerExecFactory;
    private ClientBootstrap peerBootstrap = null;
    private TpPort isisPort = TpPort.tpPort((int)3000);
    private ScheduledExecutorService connectExecutor = null;
    private int connectRetryCounter = 0;
    private int connectRetryTime;
    private ScheduledFuture future = null;
    private IsisAgent agent;

    public void isisDeactivate() {
        this.disconnectExecutor();
        this.processes = null;
        this.peerExecFactory.shutdown();
    }

    public void setAgent(IsisAgent agent) {
        this.agent = agent;
    }

    public void updateConfig(JsonNode jsonNode) throws Exception {
        log.debug("Controller::UpdateConfig called");
        this.configPacket = new byte[1498];
        byte numberOfInterface = 0;
        this.configPacket[0] = -1;
        List<IsisProcess> isisProcesses = this.getConfig(jsonNode);
        for (IsisProcess isisProcess : isisProcesses) {
            log.debug("IsisProcessDetails : " + isisProcess);
            for (IsisInterface isisInterface : isisProcess.isisInterfaceList()) {
                DefaultIsisInterface isisInterfaceImpl = (DefaultIsisInterface)isisInterface;
                log.debug("IsisInterfaceDetails : " + isisInterface);
                numberOfInterface = (byte)(numberOfInterface + 1);
                this.configPacket[2 * numberOfInterface] = (byte)isisInterfaceImpl.interfaceIndex();
                if (isisInterface.networkType() == IsisNetworkType.BROADCAST && isisInterfaceImpl.reservedPacketCircuitType() == IsisRouterType.L1.value()) {
                    this.configPacket[2 * numberOfInterface + 1] = 0;
                    continue;
                }
                if (isisInterface.networkType() == IsisNetworkType.BROADCAST && isisInterfaceImpl.reservedPacketCircuitType() == IsisRouterType.L2.value()) {
                    this.configPacket[2 * numberOfInterface + 1] = 1;
                    continue;
                }
                if (isisInterface.networkType() == IsisNetworkType.P2P) {
                    this.configPacket[2 * numberOfInterface + 1] = 2;
                    continue;
                }
                if (isisInterface.networkType() != IsisNetworkType.BROADCAST || isisInterfaceImpl.reservedPacketCircuitType() != IsisRouterType.L1L2.value()) continue;
                this.configPacket[2 * numberOfInterface + 1] = 3;
            }
        }
        this.configPacket[1] = numberOfInterface;
        if (this.processes == null) {
            if (!isisProcesses.isEmpty()) {
                this.processes = isisProcesses;
                this.connectPeer();
            }
        } else {
            this.isisChannelHandler.updateInterfaceMap(isisProcesses);
            this.isisChannelHandler.sentConfigPacket(this.configPacket);
        }
    }

    private void initConnection() {
        if (this.peerBootstrap != null) {
            return;
        }
        this.peerBootstrap = this.createPeerBootStrap();
        this.peerBootstrap.setOption("reuseAddress", (Object)true);
        this.peerBootstrap.setOption("tcpNoDelay", (Object)true);
        this.peerBootstrap.setOption("keepAlive", (Object)true);
        this.peerBootstrap.setOption("receiveBufferSize", (Object)0x400000);
        this.peerBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x400000));
        this.peerBootstrap.setOption("receiveBufferSizePredictor", (Object)new AdaptiveReceiveBufferSizePredictor(64, 1024, 65536));
        this.peerBootstrap.setOption("child.keepAlive", (Object)true);
        this.peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.peerBootstrap.setOption("child.sendBufferSize", (Object)0x400000);
        this.peerBootstrap.setOption("child.receiveBufferSize", (Object)0x400000);
        this.peerBootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x400000));
        this.peerBootstrap.setOption("child.reuseAddress", (Object)true);
        this.isisChannelHandler = new IsisChannelHandler(this, this.processes);
        IsisPipelineFactory pfact = new IsisPipelineFactory(this.isisChannelHandler);
        this.peerBootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
    }

    private ClientBootstrap createPeerBootStrap() {
        this.peerExecFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/isis", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/isis", (String)"worker-%d")), 16);
        return new ClientBootstrap((ChannelFactory)this.peerExecFactory);
    }

    public List<IsisProcess> getAllConfiguredProcesses() {
        return this.processes;
    }

    private List<IsisProcess> getConfig(JsonNode json) throws Exception {
        ArrayList<IsisProcess> isisProcessesList = new ArrayList<IsisProcess>();
        JsonNode jsonNodes = json;
        if (jsonNodes == null) {
            return isisProcessesList;
        }
        jsonNodes.forEach(jsonNode -> {
            ArrayList<DefaultIsisInterface> interfaceList = new ArrayList<DefaultIsisInterface>();
            for (JsonNode jsonNode1 : jsonNode.path("interface")) {
                int interval;
                int input;
                int input2;
                int input3;
                DefaultIsisInterface isisInterface = new DefaultIsisInterface();
                String index = jsonNode1.path("interfaceIndex").asText();
                if (this.isPrimitive(index)) {
                    int input4 = Integer.parseInt(index);
                    if (input4 < 1 || input4 > 255) {
                        log.debug("Wrong interface index: {}", (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong interface index {}", (Object)index);
                    continue;
                }
                isisInterface.setInterfaceIndex(Integer.parseInt(index));
                Ip4Address ipAddress = this.getInterfaceIp(isisInterface.interfaceIndex());
                if (ipAddress == null || ipAddress.equals((Object)IsisConstants.DEFAULTIP)) {
                    log.debug("Wrong interface index {}. No matching interface in system.", (Object)index);
                    continue;
                }
                isisInterface.setInterfaceIpAddress(ipAddress);
                MacAddress macAddress = this.getInterfaceMac(isisInterface.interfaceIndex());
                if (macAddress == null) {
                    log.debug("Wrong interface index {}. No matching interface in system.", (Object)index);
                    continue;
                }
                isisInterface.setInterfaceMacAddress(macAddress);
                String mask = this.getInterfaceMask(isisInterface.interfaceIndex());
                if (mask != null) {
                    try {
                        isisInterface.setNetworkMask(InetAddress.getByName(mask).getAddress());
                    }
                    catch (UnknownHostException e) {
                        log.debug("Wrong interface index {}. Error while getting network mask.", (Object)index);
                    }
                } else {
                    log.debug("Wrong interface index {}. Error while getting network mask.", (Object)index);
                    continue;
                }
                isisInterface.setIntermediateSystemName(jsonNode1.path("intermediateSystemName").asText());
                String systemId = jsonNode1.path("systemId").asText();
                if (!this.isValidSystemId(systemId)) {
                    log.debug("Wrong systemId: {} for interface index {}.", (Object)systemId, (Object)index);
                    continue;
                }
                isisInterface.setSystemId(systemId);
                String circuitType = jsonNode1.path("reservedPacketCircuitType").asText();
                if (this.isPrimitive(circuitType)) {
                    input3 = Integer.parseInt(circuitType);
                    if (input3 < 1 || input3 > 3) {
                        log.debug("Wrong ReservedPacketCircuitType: {} for interface index {}.", (Object)circuitType, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong ReservedPacketCircuitType: {} for interface index {}.", (Object)circuitType, (Object)index);
                    continue;
                }
                isisInterface.setReservedPacketCircuitType(input3);
                String networkType = jsonNode1.path("networkType").asText();
                if (this.isPrimitive(networkType)) {
                    input2 = Integer.parseInt(networkType);
                    if (input2 < 1 || input2 > 2) {
                        log.debug("Wrong networkType: {} for interface index {}.", (Object)networkType, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong networkType: {} for interface index {}.", (Object)networkType, (Object)index);
                    continue;
                }
                isisInterface.setNetworkType(IsisNetworkType.get((int)input2));
                String areaAddress = jsonNode1.path("areaAddress").asText();
                if (this.isPrimitive(areaAddress)) {
                    if (areaAddress.length() > 7) {
                        log.debug("Wrong areaAddress: {} for interface index {}.", (Object)areaAddress, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong areaAddress: {} for interface index {}.", (Object)areaAddress, (Object)index);
                    continue;
                }
                isisInterface.setAreaAddress(areaAddress);
                String circuitId = jsonNode1.path("circuitId").asText();
                if (this.isPrimitive(circuitId)) {
                    int input5 = Integer.parseInt(circuitId);
                    if (input5 < 1) {
                        log.debug("Wrong circuitId: {} for interface index {}.", (Object)circuitId, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong circuitId: {} for interface index {}.", (Object)circuitId, (Object)index);
                    continue;
                }
                isisInterface.setCircuitId(circuitId);
                String holdingTime = jsonNode1.path("holdingTime").asText();
                if (this.isPrimitive(holdingTime)) {
                    input = Integer.parseInt(holdingTime);
                    if (input < 1 || input > 255) {
                        log.debug("Wrong holdingTime: {} for interface index {}.", (Object)holdingTime, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong holdingTime: {} for interface index {}.", (Object)holdingTime, (Object)index);
                    continue;
                }
                isisInterface.setHoldingTime(input);
                String helloInterval = jsonNode1.path("helloInterval").asText();
                if (this.isPrimitive(helloInterval)) {
                    interval = Integer.parseInt(helloInterval);
                    if (interval <= 0 || interval > 255) {
                        log.debug("Wrong hello interval: {} for interface index {}.", (Object)helloInterval, (Object)index);
                        continue;
                    }
                } else {
                    log.debug("Wrong hello interval: {} for interface index {}.", (Object)helloInterval, (Object)index);
                    continue;
                }
                isisInterface.setHelloInterval(interval);
                interfaceList.add(isisInterface);
            }
            if (!interfaceList.isEmpty()) {
                DefaultIsisProcess process = new DefaultIsisProcess();
                process.setProcessId(jsonNode.path("processId").asText());
                process.setIsisInterfaceList(interfaceList);
                isisProcessesList.add(process);
            }
        });
        return isisProcessesList;
    }

    private MacAddress getInterfaceMac(int interfaceIndex) {
        MacAddress macAddress = null;
        try {
            NetworkInterface networkInterface = NetworkInterface.getByIndex(interfaceIndex);
            macAddress = MacAddress.valueOf((byte[])networkInterface.getHardwareAddress());
        }
        catch (Exception e) {
            log.debug("Error while getting Interface IP by index");
            return macAddress;
        }
        return macAddress;
    }

    private Ip4Address getInterfaceIp(int interfaceIndex) {
        Ip4Address ipAddress = null;
        try {
            NetworkInterface networkInterface = NetworkInterface.getByIndex(interfaceIndex);
            Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress address = ipAddresses.nextElement();
                if (address.isLinkLocalAddress()) continue;
                ipAddress = Ip4Address.valueOf((byte[])address.getAddress());
                break;
            }
        }
        catch (Exception e) {
            log.debug("Error while getting Interface IP by index");
            return IsisConstants.DEFAULTIP;
        }
        return ipAddress;
    }

    private String getInterfaceMask(int interfaceIndex) {
        String subnetMask = null;
        try {
            InetAddress address;
            Ip4Address ipAddress = this.getInterfaceIp(interfaceIndex);
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(ipAddress.toString()));
            Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
            int index = 0;
            while (ipAddresses.hasMoreElements() && (address = ipAddresses.nextElement()).isLinkLocalAddress()) {
                ++index;
            }
            short prfLen = networkInterface.getInterfaceAddresses().get(index).getNetworkPrefixLength();
            int shft = -1 << 32 - prfLen;
            int oct1 = (byte)((shft & 0xFF000000) >> 24) & 0xFF;
            int oct2 = (byte)((shft & 0xFF0000) >> 16) & 0xFF;
            int oct3 = (byte)((shft & 0xFF00) >> 8) & 0xFF;
            int oct4 = (byte)(shft & 0xFF) & 0xFF;
            subnetMask = oct1 + "." + oct2 + "." + oct3 + "." + oct4;
        }
        catch (Exception e) {
            log.debug("Error while getting Interface network mask by index");
            return subnetMask;
        }
        return subnetMask;
    }

    private boolean isPrimitive(String value) {
        boolean status = true;
        if ((value = value.trim()).length() < 1) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c)) continue;
            status = false;
            break;
        }
        return status;
    }

    private boolean isValidSystemId(String value) {
        value = value.trim();
        boolean status = true;
        if (value.length() != 14) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c) || (i == 4 || i == 9) && c == '.') continue;
            status = false;
            break;
        }
        return status;
    }

    public void disconnectExecutor() {
        if (this.connectExecutor != null) {
            this.future.cancel(true);
            this.connectExecutor.shutdownNow();
            this.connectExecutor = null;
        }
    }

    public void connectPeer() {
        this.scheduleConnectionRetry(this.connectRetryTime);
    }

    private void scheduleConnectionRetry(long retryDelay) {
        if (this.connectExecutor == null) {
            this.connectExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.future = this.connectExecutor.schedule(new ConnectionRetry(), retryDelay, TimeUnit.MINUTES);
    }

    public void addDeviceDetails(IsisRouter isisRouter) {
        this.agent.addConnectedRouter(isisRouter);
    }

    public void removeDeviceDetails(IsisRouter isisRouter) {
        this.agent.removeConnectedRouter(isisRouter);
    }

    public void addLinkDetails(IsisLink isisLink) {
        this.agent.addLink(isisLink);
    }

    public void removeLinkDetails(IsisLink isisLink) {
        this.agent.deleteLink(isisLink);
    }

    public IsisAgent agent() {
        return this.agent;
    }

    class ConnectionRetry
    implements Runnable {
        ConnectionRetry() {
        }

        @Override
        public void run() {
            log.debug("Connect to peer {}", (Object)"127.0.0.1");
            Controller.this.initConnection();
            Controller.this.isisChannelHandler.sentConfigPacket(Controller.this.configPacket);
            InetSocketAddress connectToSocket = new InetSocketAddress("127.0.0.1", Controller.this.isisPort.toInt());
            try {
                Controller.this.peerBootstrap.connect((SocketAddress)connectToSocket).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            Controller.this.connectRetryCounter++;
                            log.error("Connection failed, ConnectRetryCounter {} remote host {}", (Object)Controller.this.connectRetryCounter, (Object)"127.0.0.1");
                            if (Controller.this.connectRetryTime < 4) {
                                Controller.this.connectRetryTime = Controller.this.connectRetryTime != 0 ? Controller.this.connectRetryTime * 2 : 1;
                            }
                        } else {
                            Controller.this.isisChannelHandler.sentConfigPacket(Controller.this.configPacket);
                            Controller.this.connectRetryCounter++;
                            log.info("Connected to remote host {}, Connect Counter {}", (Object)"127.0.0.1", (Object)Controller.this.connectRetryCounter);
                            Controller.this.disconnectExecutor();
                            return;
                        }
                        Controller.this.scheduleConnectionRetry(Controller.this.connectRetryTime);
                    }
                });
            }
            catch (Exception e) {
                log.info("Connect peer exception : " + e.toString());
                Controller.this.disconnectExecutor();
            }
        }
    }
}

