/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp.trapsender;

import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.model.INotification;
import com.btisystems.pronx.ems.core.snmp.ISnmpNotificationOidLookup;
import com.btisystems.pronx.ems.core.snmp.OIDComparator;
import com.btisystems.pronx.ems.core.snmp.trapsender.ITrapSender;
import com.btisystems.pronx.ems.core.snmp.trapsender.TrapRecipient;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapSender
implements ITrapSender {
    private static final Logger LOG = LoggerFactory.getLogger(TrapSender.class);
    protected Snmp snmp;

    @Override
    public void send(INotification notification, ISnmpNotificationOidLookup lookup, List<TrapRecipient> trapRecipients) {
        PDU trap = new PDU();
        trap.setType(-89);
        TimeTicks uptime = new TimeTicks();
        uptime.fromMilliseconds(ManagementFactory.getRuntimeMXBean().getUptime());
        trap.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)uptime));
        trap.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)notification.get_Description().getOid()));
        this.buildPayload(notification, lookup, trap);
        for (TrapRecipient trapReceiver : trapRecipients) {
            this.sendTrap(trapReceiver, trap);
        }
    }

    private void buildPayload(INotification notification, ISnmpNotificationOidLookup lookup, PDU trap) {
        TreeMap<String, VariableBinding> variables = new TreeMap<String, VariableBinding>(new OIDComparator());
        for (DeviceEntityDescription.FieldDescription fieldDescription : notification.get_Description().getFields()) {
            Variable variable = this.buildVarBind(fieldDescription, notification);
            if (variable == null) continue;
            OID oid = lookup.lookupOidForField(fieldDescription);
            variables.put(oid.toString(), new VariableBinding(oid, variable));
        }
        if (!variables.isEmpty()) {
            trap.addAll(variables.values().toArray(new VariableBinding[variables.size()]));
        }
    }

    private void sendTrap(TrapRecipient trapReceiver, PDU trap) {
        try {
            UdpAddress targetaddress = new UdpAddress(InetAddress.getByName(trapReceiver.getIpAddress()), trapReceiver.getPort());
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(trapReceiver.getCommunity()));
            target.setVersion(1);
            target.setAddress((Address)targetaddress);
            this.createSnmpSession();
            LOG.trace("Sending trap:{} to {} ...", (Object)trap, (Object)trapReceiver);
            this.snmp.send(trap, (Target)target);
        }
        catch (IOException ex) {
            LOG.error("Error sending trap:" + trap + " to receiver:" + trapReceiver, (Throwable)ex);
        }
    }

    private Variable buildVarBind(DeviceEntityDescription.FieldDescription fieldDescription, INotification notification) {
        Variable result = null;
        switch (fieldDescription.getType()) {
            case FIXED_X10: 
            case FIXED_X100: 
            case FIXED_X1000: 
            case INTEGER: {
                result = this.buildNumber(notification, fieldDescription);
                break;
            }
            case STRING: 
            case BITS: 
            case OID: {
                result = this.buildString(notification, fieldDescription);
                break;
            }
            case DATE_AND_TIME: {
                result = this.buildDateTime(notification, fieldDescription);
                break;
            }
            case IP_ADDRESS: {
                result = this.buildIPAddress(notification, fieldDescription);
                break;
            }
            case UNSIGNED32: {
                result = this.buildUnsigned(notification, fieldDescription);
                break;
            }
            default: {
                LOG.error("Unexpected type in Notification: {}", (Object)fieldDescription);
            }
        }
        return result;
    }

    protected void createSnmpSession() throws IOException {
        if (this.snmp == null) {
            this.snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        }
    }

    private Variable buildNumber(INotification notification, DeviceEntityDescription.FieldDescription fieldDescription) {
        Integer32 result = new Integer32(notification.getInt(fieldDescription.getName()));
        return result;
    }

    private Variable buildString(INotification notification, DeviceEntityDescription.FieldDescription fieldDescription) {
        OctetString result = null;
        if (notification.getString(fieldDescription.getName()) != null) {
            result = new OctetString(notification.getString(fieldDescription.getName()));
        }
        return result;
    }

    private Variable buildDateTime(INotification notification, DeviceEntityDescription.FieldDescription fieldDescription) {
        OctetString result = null;
        if (notification.getString(fieldDescription.getName()) != null) {
            result = OctetString.fromHexString((String)notification.getString(fieldDescription.getName()), (char)':');
        }
        return result;
    }

    private Variable buildIPAddress(INotification notification, DeviceEntityDescription.FieldDescription fieldDescription) {
        IpAddress result = null;
        if (notification.getString(fieldDescription.getName()) != null) {
            result = new IpAddress(notification.getString(fieldDescription.getName()));
        }
        return result;
    }

    private Variable buildUnsigned(INotification notification, DeviceEntityDescription.FieldDescription fieldDescription) {
        UnsignedInteger32 result = new UnsignedInteger32(notification.getInt(fieldDescription.getName()));
        return result;
    }
}

