/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp.trapreceiver;

import com.btisystems.pronx.ems.core.snmp.trapreceiver.ITrapSourceMapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapSourceMapper
implements ITrapSourceMapper {
    public static final String REGEX = "\\.";
    private static final String IP_DELIMETER = ".";
    private static final String RANGE_DELIMETER = "-";
    private static final int IP_TOKENS = 4;
    private static final int IP_END_TOKEN = 3;
    private static Logger log = LoggerFactory.getLogger(TrapSourceMapper.class);
    private String mapSourceAddress = null;
    private List<String> targetAddressList;
    private int mappedAddressIndex = 0;

    public TrapSourceMapper(String sourceMapping) {
        log.info("Apply trap source mapping:{}", (Object)sourceMapping);
        String[] tokens = sourceMapping.split(":");
        if (tokens.length == 2) {
            this.targetAddressList = this.buildMappedAddressList(tokens[1]);
            if (this.targetAddressList != null && !this.targetAddressList.isEmpty()) {
                this.mapSourceAddress = tokens[0];
            }
        }
    }

    private List<String> buildMappedAddressList(String addressListDefinition) {
        String[] tokens;
        log.info("buildMappedAddressList from {}", (Object)addressListDefinition);
        ArrayList<String> targetAddresses = new ArrayList<String>();
        for (String token : tokens = addressListDefinition.split(",")) {
            int rangeIndex = token.indexOf(45);
            if (rangeIndex == -1) {
                targetAddresses.add(token);
                continue;
            }
            targetAddresses.addAll(this.getAddressesInRange(token));
        }
        return targetAddresses;
    }

    private List<String> getAddressesInRange(String rangeDescription) {
        String[] startEndTokens;
        log.debug("getAddressesInRange from {}", (Object)rangeDescription);
        ArrayList<String> rangeAddresses = new ArrayList<String>();
        String[] tokens = rangeDescription.split(REGEX);
        if (tokens.length == 4 && (startEndTokens = tokens[3].split(RANGE_DELIMETER)).length == 2) {
            this.addRangeAddresses(startEndTokens, tokens, rangeAddresses, rangeDescription);
        }
        return rangeAddresses;
    }

    private void addRangeAddresses(String[] startEndTokens, String[] tokens, List<String> rangeAddresses, String rangeDescription) {
        try {
            int startIndex = Integer.parseInt(startEndTokens[0]);
            int endIndex = Integer.parseInt(startEndTokens[1]);
            for (int i = startIndex; i <= endIndex; ++i) {
                String address = tokens[0] + IP_DELIMETER + tokens[1] + IP_DELIMETER + tokens[2] + IP_DELIMETER + i;
                log.debug("added address {}", (Object)address);
                rangeAddresses.add(address);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring invalid range description {}", (Object)rangeDescription);
        }
    }

    @Override
    public String mapAddress(String remoteAddress) {
        if (remoteAddress.equals(this.mapSourceAddress)) {
            if (this.mappedAddressIndex == this.targetAddressList.size()) {
                this.mappedAddressIndex = 0;
            }
            return this.targetAddressList.get(this.mappedAddressIndex++);
        }
        return remoteAddress;
    }
}

