/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp.trapreceiver;

import com.btisystems.pronx.ems.core.snmp.trapreceiver.ITrapHandlerService;
import com.btisystems.pronx.ems.core.snmp.trapreceiver.ITrapReceiver;
import com.btisystems.pronx.ems.core.snmp.trapreceiver.ITrapReceiverConfiguration;
import com.btisystems.pronx.ems.core.snmp.trapreceiver.ITrapSourceMapper;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TrapReceiver
implements ITrapReceiver {
    public static final char SLASH = '/';
    public static final String PORT = "/161";
    private static final Logger LOG = LoggerFactory.getLogger(TrapReceiver.class);
    private static final String TCP_TRANSPORT = "tcp";
    private static final String UDP_TRANSPORT = "udp";
    private static OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    protected ITrapReceiverConfiguration config;
    protected ITrapSourceMapper addressMapper;
    protected Address listeningAddress;
    protected ITrapHandlerService trapHandlerService;
    protected int dispatcherThreadCount;
    private OctetString authoritativeEngineID;

    @Override
    public synchronized void setConfiguration(ITrapReceiverConfiguration config) {
        this.config = config;
        this.listeningAddress = this.getAddress(config.getListeningAddress());
        this.trapHandlerService = config.getTrapHandlerService();
        this.addressMapper = config.getAddressMapper();
        this.dispatcherThreadCount = config.getDispatcherThreadCount();
    }

    @Override
    public synchronized void startReceiving() {
        LOG.debug(">>> receiveTraps");
        try {
            ThreadPool threadPool = ThreadPool.create((String)"DispatcherPool", (int)this.config.getDispatcherThreadCount());
            MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher((WorkerPool)threadPool, (MessageDispatcher)new MessageDispatcherImpl());
            mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
            mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv3(localEngineID.getValue()));
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new Priv3DES());
            Snmp snmp = this.createSnmp((MessageDispatcher)mtDispatcher);
            USM usm = new USM(SecurityProtocols.getInstance(), localEngineID, 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            if (this.authoritativeEngineID != null) {
                snmp.setLocalEngine(this.authoritativeEngineID.getValue(), 0, 0);
            }
            snmp.addNotificationListener(this.listeningAddress, (CommandResponder)this);
            snmp.listen();
            LOG.info("Listening for notifications on {}", (Object)this.listeningAddress);
            this.waitWhileListening();
        }
        catch (IOException e) {
            LOG.debug("Failed listening for traps:", (Throwable)e);
            LOG.warn("IOException listening for traps:{}", (Object)e.getMessage());
        }
    }

    protected Snmp createSnmp(MessageDispatcher mtDispatcher) {
        if (mtDispatcher == null) {
            throw new IllegalArgumentException("Message Dispatcher cannot be null");
        }
        Snmp snmp = new Snmp(mtDispatcher);
        return snmp;
    }

    protected synchronized void waitWhileListening() {
        try {
            while (true) {
                this.wait();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    protected Address getAddress(String transportAddress) {
        String transport = UDP_TRANSPORT;
        String modifiedAddress = transportAddress;
        int colon = modifiedAddress.indexOf(58);
        if (colon > 0) {
            transport = modifiedAddress.substring(0, colon);
            modifiedAddress = modifiedAddress.substring(colon + 1);
        }
        if (modifiedAddress.indexOf(47) < 0) {
            modifiedAddress = modifiedAddress + PORT;
        }
        if (transport.equalsIgnoreCase(UDP_TRANSPORT)) {
            return new UdpAddress(modifiedAddress);
        }
        if (transport.equalsIgnoreCase(TCP_TRANSPORT)) {
            return new TcpAddress(modifiedAddress);
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    public synchronized void processPdu(CommandResponderEvent e) {
        Date timeNow = new Date();
        PDU command = e.getPDU();
        String remoteAddress = this.getRemoteAddress(e);
        String resolvedAddress = this.resolveAddress(remoteAddress);
        e.setProcessed(true);
        if (command != null) {
            switch (command.getType()) {
                case -92: 
                case -90: 
                case -89: {
                    this.processNotification(remoteAddress, command, timeNow, resolvedAddress);
                    break;
                }
                default: {
                    LOG.warn("Unsupported PDU from:" + remoteAddress + ":" + command.toString());
                }
            }
        }
    }

    private String resolveAddress(String remoteAddress) {
        String resolvedAddress = remoteAddress;
        if (this.addressMapper != null) {
            resolvedAddress = this.addressMapper.mapAddress(remoteAddress);
        }
        return resolvedAddress;
    }

    private String getRemoteAddress(CommandResponderEvent e) {
        return ((IpAddress)e.getPeerAddress()).getInetAddress().getHostAddress();
    }

    private void processNotification(String remoteAddress, PDU command, Date timeNow, String resolvedAddress) {
        LOG.debug("Trap received from address = {} containing command = {}", (Object)remoteAddress, (Object)command);
        this.trapHandlerService.handle(timeNow, resolvedAddress, command);
    }
}

