/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalkResponse {
    public static final String SUCCESS = "success";
    public static final String FAILED = "failed:";
    public static final String NO_IDEA = "???";
    private static Logger log = LoggerFactory.getLogger(WalkResponse.class);
    private final boolean isSuccess;
    private final Throwable throwable;
    private long walkTime;
    private long pingTime;
    private int objectCount;
    private int requestCount;

    public WalkResponse(boolean isSuccess) {
        log.debug(">>> DeviceDiscoveryResponse:{}", (Object)isSuccess);
        this.isSuccess = isSuccess;
        this.throwable = null;
    }

    public WalkResponse(Throwable throwable) {
        this.isSuccess = false;
        this.throwable = throwable;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        if (this.isSuccess) {
            return SUCCESS;
        }
        return FAILED + (this.throwable != null ? this.throwable.getMessage() : NO_IDEA);
    }

    public long getWalkTime() {
        return this.walkTime;
    }

    public void setWalkTime(long walkTime) {
        this.walkTime = walkTime;
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public void setPingTime(long pingTime) {
        this.pingTime = pingTime;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(int objectCount) {
        this.objectCount = objectCount;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }
}

