/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import com.btisystems.pronx.ems.core.snmp.SnmpConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class V2cSnmpConfiguration
extends SnmpConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(V2cSnmpConfiguration.class);

    public V2cSnmpConfiguration() {
        LOG.debug(">>> V2cSnmpConfiguration");
        this.setVersion(1);
    }

    @Override
    public Target createTarget(Address address) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.getCommunity()));
        target.setAddress(address);
        target.setVersion(this.getVersion());
        target.setRetries(this.getRetries());
        target.setTimeout((long)this.getTimeout());
        target.setMaxSizeRequestPDU(this.getMaxSizeResponsePDU());
        return target;
    }

    @Override
    public PDU createPDU(int type) {
        PDU pdu = new PDU();
        pdu.setType(type);
        switch (type) {
            case -91: {
                pdu.setMaxRepetitions(this.getMaxRepetitions());
                pdu.setNonRepeaters(this.getNonRepeaters());
                break;
            }
            default: {
                LOG.trace("Not setting up non-default configuration for PDU type {}.", (Object)type);
            }
        }
        return pdu;
    }

    @Override
    public Snmp createSnmpSession(TransportMapping transportMapping) throws IOException {
        ThreadPool threadPool = ThreadPool.create((String)"SnmpDispatcherPool", (int)this.getDispatcherPoolSize());
        MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher((WorkerPool)threadPool, (MessageDispatcher)new MessageDispatcherImpl());
        mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        Snmp snmp = new Snmp((MessageDispatcher)mtDispatcher, transportMapping);
        snmp.listen();
        return snmp;
    }

    public String toString() {
        return "V2cSnmpConfiguration{version=" + this.getVersion() + ", retries=" + this.getRetries() + ", timeout=" + this.getTimeout() + ", maxRepetitions=" + this.getMaxRepetitions() + ", nonRepeaters=" + this.getNonRepeaters() + ", maxSizeResponsePDU=" + this.getMaxSizeResponsePDU() + ", walkTimeout=" + this.getWalkTimeout() + ", port=" + this.getPort() + ", dispatcherPoolSize=" + this.getDispatcherPoolSize() + ", maximumRowsPerPdu=" + this.getMaximumRowsPerPdu() + ", maximumColumnsPerPdu=" + this.getMaximumColumnsPerPdu() + ", community=" + this.getCommunity() + '}';
    }
}

