/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpTableWalker;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import com.btisystems.pronx.ems.core.snmp.WalkException;
import com.btisystems.pronx.ems.core.snmp.WalkResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

public class SnmpTableWalker
extends DefaultPDUFactory
implements ISnmpTableWalker {
    private static final Logger log = LoggerFactory.getLogger(SnmpTableWalker.class);
    private static final Logger walkerLog = LoggerFactory.getLogger((String)(ISnmpSession.class.getName() + ".walk"));
    private final ISnmpConfiguration snmpConfiguration;
    private final Target target;
    private final Address address;
    private final Session snmpInterface;

    public SnmpTableWalker(ISnmpConfiguration snmpConfiguration, Session snmp, Target target, Address address) {
        this.snmpConfiguration = snmpConfiguration;
        this.snmpInterface = snmp;
        this.address = address;
        this.target = target;
    }

    @Override
    public WalkResponse getTableRows(IVariableBindingHandler networkDevice, Map<DeviceEntityDescription, List<OID>> tableIndexes) throws IOException {
        Iterator<TableIndexRetrievalDescriptor> retrievalIterator = this.getTableRetrievalDescriptors(tableIndexes).iterator();
        if (retrievalIterator.hasNext()) {
            TableUtils tableUtils = this.newTableUtility();
            TableResponseListener listener = new TableResponseListener(networkDevice);
            do {
                TableIndexRetrievalDescriptor indexRetrieval;
                WalkResponse response;
                if ((response = this.retrieveRowsWithIndex(tableUtils, listener, indexRetrieval = retrievalIterator.next())) == null) continue;
                return response;
            } while (!listener.hadError() && retrievalIterator.hasNext());
            return listener.getResponse();
        }
        return new WalkResponse(new WalkException("Nothing to retrieve"));
    }

    private Collection<TableIndexRetrievalDescriptor> getTableRetrievalDescriptors(Map<DeviceEntityDescription, List<OID>> tableIndexes) {
        HashMap<OID, TableIndexRetrievalDescriptor> descriptorMap = new HashMap<OID, TableIndexRetrievalDescriptor>();
        for (Map.Entry<DeviceEntityDescription, List<OID>> entry : tableIndexes.entrySet()) {
            DeviceEntityDescription deviceEntityDescription = entry.getKey();
            Collection<DeviceEntityDescription.FieldDescription> columnDescriptions = deviceEntityDescription.getFields();
            for (OID indexOid : entry.getValue()) {
                TableIndexRetrievalDescriptor descriptor = (TableIndexRetrievalDescriptor)descriptorMap.get(indexOid);
                if (descriptor == null) {
                    descriptor = new TableIndexRetrievalDescriptor(indexOid);
                    descriptorMap.put(indexOid, descriptor);
                }
                for (DeviceEntityDescription.FieldDescription columnDescription : columnDescriptions) {
                    OID columnOid = new OID(deviceEntityDescription.getOid());
                    columnOid.append(columnDescription.getId());
                    log.debug("Add OID for column:{}", (Object)columnOid);
                    descriptor.columnOids.add(columnOid);
                }
            }
        }
        return descriptorMap.values();
    }

    private TableUtils newTableUtility() {
        TableUtils tableUtils = new TableUtils(this.snmpInterface, (PDUFactory)this);
        if (this.snmpConfiguration.getMaximumColumnsPerPdu() != 0) {
            tableUtils.setMaxNumColumnsPerPDU(this.snmpConfiguration.getMaximumColumnsPerPdu());
        }
        if (this.snmpConfiguration.getMaximumRowsPerPdu() != 0) {
            tableUtils.setMaxNumRowsPerPDU(this.snmpConfiguration.getMaximumRowsPerPdu());
        }
        return tableUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WalkResponse retrieveRowsWithIndex(TableUtils tableUtils, TableResponseListener listener, TableIndexRetrievalDescriptor indexRetrieval) {
        walkerLog.debug("retrieve columns {} with index {}", (Object)indexRetrieval.getColumnOids(), (Object)indexRetrieval.lowIndex);
        listener.reset();
        TableResponseListener tableResponseListener = listener;
        synchronized (tableResponseListener) {
            tableUtils.getTable(this.target, indexRetrieval.getColumnOids(), (TableListener)listener, null, indexRetrieval.lowIndex, indexRetrieval.highIndex);
            try {
                if (!listener.isFinished()) {
                    long startTime = System.currentTimeMillis();
                    while (!listener.isFinished() && System.currentTimeMillis() - startTime < (long)this.snmpConfiguration.getWalkTimeout()) {
                        listener.wait(this.snmpConfiguration.getWalkTimeout());
                    }
                    if (!listener.isFinished()) {
                        listener.stopWalk();
                        log.error("Table Walk for device {} timed out.", (Object)this.getHostAddress());
                        return new WalkResponse(new WalkException("Walk timed out"));
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                walkerLog.warn("listener wait interrupted:{}", (Throwable)ex);
            }
        }
        return null;
    }

    private String getHostAddress() {
        return ((IpAddress)this.address).getInetAddress().getHostAddress();
    }

    public PDU createPDU(Target target) {
        PDU request = new PDU();
        request.setType(-91);
        return request;
    }

    private class TableIndexRetrievalDescriptor {
        protected OID lowIndex;
        protected OID highIndex;
        protected Set<OID> columnOids;

        public TableIndexRetrievalDescriptor(OID indexOid) {
            if (indexOid.last() == 0) {
                this.lowIndex = indexOid.trim();
            } else {
                this.lowIndex = new OID(indexOid);
                this.lowIndex.set(indexOid.size() - 1, indexOid.last() - 1);
            }
            this.highIndex = indexOid;
            this.columnOids = new TreeSet<OID>();
        }

        public OID[] getColumnOids() {
            return this.columnOids.toArray(new OID[this.columnOids.size()]);
        }
    }

    private class TableResponseListener
    implements TableListener {
        private final long startTime = System.currentTimeMillis();
        private final IVariableBindingHandler networkDevice;
        private boolean finished;
        private int requests;
        private int objects;
        private WalkResponse response;

        public TableResponseListener(IVariableBindingHandler networkDevice) {
            this.networkDevice = networkDevice;
            this.finished = false;
        }

        public WalkResponse getResponse() {
            if (this.response != null) {
                return this.response;
            }
            if (!this.finished) {
                return new WalkResponse(new WalkException("Walk interrupted"));
            }
            long walkTime = System.currentTimeMillis() - this.startTime;
            walkerLog.debug("requests:{}, objects:{}", (Object)this.requests, (Object)this.objects);
            walkerLog.debug("time:{}", (Object)walkTime);
            this.response = new WalkResponse(true);
            this.response.setObjectCount(this.objects);
            this.response.setRequestCount(this.requests);
            this.response.setWalkTime(walkTime);
            return this.response;
        }

        public void stopWalk() {
            this.finished = true;
        }

        public boolean next(TableEvent e) {
            VariableBinding[] vbs;
            ++this.requests;
            for (VariableBinding vb : vbs = e.getColumns()) {
                if (vb != null) {
                    this.addVariable(vb);
                }
                ++this.objects;
            }
            return !this.finished;
        }

        public boolean hadError() {
            return this.response != null;
        }

        private boolean addVariable(VariableBinding binding) {
            walkerLog.debug(">>> addVariable:{}", (Object)binding);
            try {
                boolean wasAdded = this.networkDevice.addVariable(binding);
                if (!wasAdded) {
                    return false;
                }
            }
            catch (Exception e) {
                walkerLog.warn("Exception adding variable binding:{} {} from " + SnmpTableWalker.this.getHostAddress(), (Object)binding, (Object)e);
            }
            return true;
        }

        public void reset() {
            this.finished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent e) {
            walkerLog.debug("Finished table request");
            if (e.getColumns() != null && e.getColumns().length > 0) {
                this.next(e);
            }
            if (e.isError()) {
                log.error("Exception when walking:" + e.getErrorMessage(), (Throwable)e.getException());
                this.response = new WalkResponse(new WalkException(e.getErrorMessage()));
            }
            this.finished = true;
            TableResponseListener tableResponseListener = this;
            synchronized (tableResponseListener) {
                this.notify();
            }
        }

        public boolean isFinished() {
            walkerLog.debug("isFinished {}", (Object)this.finished);
            return this.finished;
        }
    }
}

