/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpSessionFactory;
import com.btisystems.pronx.ems.core.snmp.SnmpSession;
import com.btisystems.pronx.ems.core.snmp.V2cSnmpConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpSessionFactory
implements ISnmpSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpSessionFactory.class);
    private final ISnmpConfigurationFactory configurationFactory;
    private Session defaultSnmpInterface;

    public SnmpSessionFactory(ISnmpConfigurationFactory defaultConfigurationFactory) {
        this.configurationFactory = defaultConfigurationFactory;
    }

    @Override
    public ISnmpSession createSession(ISnmpConfiguration configuration, String ipAddress) throws IOException {
        LOG.debug(">>> createSession address:{}", (Object)ipAddress);
        Address address = SnmpSessionFactory.getAddress(ipAddress, configuration.getPort());
        Session snmpInterface = this.getDefaultSnmpInterface();
        Target target = configuration.createTarget(address);
        return new SnmpSession(configuration, snmpInterface, target, address);
    }

    @Override
    public ISnmpSession createSession(String ipAddress, String communityString) throws IOException {
        LOG.debug(">>> createSession address:{}", (Object)ipAddress);
        ISnmpConfiguration configuration = this.configurationFactory.getConfiguration(ISnmpConfigurationFactory.AccessType.READ_WRITE);
        if (configuration instanceof V2cSnmpConfiguration && communityString != null) {
            ((V2cSnmpConfiguration)configuration).setCommunity(communityString);
        }
        return this.createSession(configuration, ipAddress);
    }

    @Override
    public ISnmpSession createSession(String ipAddress, String communityString, String factoryName, ISnmpConfigurationFactory.AccessType accessType) throws IOException {
        throw new UnsupportedOperationException("Alternative configuration factory not supported.");
    }

    private static Address getAddress(String transportAddress, int port) {
        String address = transportAddress;
        String transport = "udp";
        int colon = address.indexOf(58);
        if (colon > 0) {
            transport = address.substring(0, colon);
            address = address.substring(colon + 1);
        }
        if (address.indexOf(47) < 0) {
            address = address + "/" + port;
        }
        if (transport.equalsIgnoreCase("udp")) {
            return new UdpAddress(address);
        }
        if (transport.equalsIgnoreCase("tcp")) {
            return new TcpAddress(address);
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getDefaultSnmpInterface() throws IOException {
        ISnmpConfigurationFactory iSnmpConfigurationFactory = this.configurationFactory;
        synchronized (iSnmpConfigurationFactory) {
            if (this.defaultSnmpInterface == null) {
                ISnmpConfiguration defaultSnmpConfiguration = this.configurationFactory.getConfiguration(ISnmpConfigurationFactory.AccessType.READ_WRITE);
                this.defaultSnmpInterface = defaultSnmpConfiguration.createSnmpSession((TransportMapping)new DefaultUdpTransportMapping());
            }
            LOG.debug("Using default SnmpInterface!");
        }
        return this.defaultSnmpInterface;
    }
}

