/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import com.btisystems.pronx.ems.core.exception.SystemObjectIdException;
import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpTableWalker;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import com.btisystems.pronx.ems.core.snmp.SnmpIoException;
import com.btisystems.pronx.ems.core.snmp.SnmpTableWalker;
import com.btisystems.pronx.ems.core.snmp.WalkException;
import com.btisystems.pronx.ems.core.snmp.WalkResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SnmpSession
extends DefaultPDUFactory
implements ISnmpSession {
    public static final String SPACE = " ";
    protected static final Logger LOG = LoggerFactory.getLogger(SnmpSession.class);
    protected static final Logger SETTER_LOG = LoggerFactory.getLogger((String)(ISnmpSession.class.getName() + ".set"));
    protected static final Logger WALKER_LOG = LoggerFactory.getLogger((String)(ISnmpSession.class.getName() + ".walk"));
    private static final String SYSTEM_OBJECT_ID_OID = "1.3.6.1.2.1.1.2.0";
    private static final String NO_SUCH_OBJECT = "noSuchObject";
    private static final String NULL = "Null";
    private final ISnmpConfiguration snmpConfiguration;
    private final Target target;
    private final Address address;
    private final Session snmpInterface;
    private final ISnmpTableWalker tableWalker;

    public SnmpSession(ISnmpConfiguration snmpConfiguration, Session snmp, Target target, Address address) {
        this.snmpConfiguration = snmpConfiguration;
        this.snmpInterface = snmp;
        this.address = address;
        this.target = target;
        this.tableWalker = new SnmpTableWalker(snmpConfiguration, snmp, target, address);
    }

    @Override
    public String identifyDevice() {
        LOG.debug(">>> identifyDevice address:{}", (Object)this.getHostAddress());
        try {
            return this.getVariableValue(SYSTEM_OBJECT_ID_OID).toString();
        }
        catch (IOException e) {
            throw new SystemObjectIdException(this.address, (Throwable)e);
        }
    }

    @Override
    public String getVariable(String oid) {
        LOG.debug(">>> getVariable oid:{}, address:{}", (Object)oid, (Object)this.getHostAddress());
        try {
            return this.getVariableValue(oid).toString();
        }
        catch (IOException e) {
            LOG.debug("Ignoring IOException {}", (Object)e.getMessage());
            LOG.trace("IOException {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public Integer getVariableAsInt(String oid) {
        LOG.debug(">>> getVariableAsInt oid:{}, address:{}", (Object)oid, (Object)this.getHostAddress());
        try {
            return this.getVariableValue(oid).toInt();
        }
        catch (IOException e) {
            LOG.debug("Ignoring IOException {}", (Object)e.getMessage());
            LOG.trace("IOException {}", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WalkResponse walkDevice(IVariableBindingHandler networkDevice, List<OID> oids) {
        TreeResponseListener treeListener;
        WALKER_LOG.debug(">>> walkDevice address:{}", (Object)this.getHostAddress());
        WALKER_LOG.trace(">>> walkDevice address:{} for oids={}", (Object)this.getHostAddress(), oids);
        TreeUtils treeUtils = new TreeUtils(this.snmpInterface, (PDUFactory)this);
        TreeResponseListener treeResponseListener = treeListener = new TreeResponseListener(networkDevice, oids, treeUtils);
        synchronized (treeResponseListener) {
            treeUtils.setIgnoreLexicographicOrder(true);
            treeUtils.setMaxRepetitions(this.snmpConfiguration.getMaxRepetitions());
            WALKER_LOG.debug("NE:{},  First subtree:{}", (Object)this.getHostAddress(), (Object)oids.get(0));
            treeUtils.getSubtree(this.target, oids.get(0), (Object)this, (TreeListener)treeListener);
            try {
                if (!treeListener.isFinished()) {
                    long startTime = System.currentTimeMillis();
                    while (!treeListener.isFinished() && System.currentTimeMillis() - startTime < (long)this.snmpConfiguration.getWalkTimeout()) {
                        treeListener.wait(this.snmpConfiguration.getWalkTimeout());
                    }
                    if (!treeListener.isFinished()) {
                        treeListener.stopWalk();
                        LOG.error("Walk for device {} timed out.", (Object)this.getHostAddress());
                        return new WalkResponse(new WalkException("Walk timed out"));
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                WALKER_LOG.warn("listener wait interrupted:{}", (Throwable)ex);
            }
            return treeListener.getResponse();
        }
    }

    @Override
    public WalkResponse getTableRows(IVariableBindingHandler networkDevice, Map<DeviceEntityDescription, List<OID>> tableIndexes) throws IOException {
        return this.getTableWalker().getTableRows(networkDevice, tableIndexes);
    }

    @Override
    public InetAddress getAddress() {
        return ((IpAddress)this.address).getInetAddress();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setVariables(VariableBinding[] bindings) {
        String hostIp = this.getHostAddress();
        SETTER_LOG.debug(">>> setVariable bindings:{}, address {}", (Object)bindings, (Object)hostIp);
        PDU request = this.snmpConfiguration.createPDU(-93);
        request.addAll(bindings);
        ResponseEvent responseEvent = this.send(request, hostIp);
        this.processResponseEvent(responseEvent, hostIp);
    }

    private ResponseEvent send(PDU request, String hostIp) throws SnmpIoException {
        ResponseEvent responseEvent;
        try {
            responseEvent = this.snmpInterface.send(request, this.target);
        }
        catch (IOException e) {
            LOG.debug("Failed to set variables:", (Throwable)e);
            SETTER_LOG.warn("IO Exception sending to host {}, message={}", (Object)hostIp, (Object)e.getMessage());
            throw new SnmpIoException(hostIp, e.getMessage());
        }
        return responseEvent;
    }

    private void processResponseEvent(ResponseEvent responseEvent, String hostIp) throws SnmpIoException {
        if (responseEvent.getError() != null) {
            SETTER_LOG.warn("Response when sending to host {} has error: {}", (Object)hostIp, (Object)responseEvent.getError().getMessage());
            throw new SnmpIoException(hostIp, responseEvent.getError().getMessage());
        }
        PDU response = responseEvent.getResponse();
        if (response != null) {
            int errorStatusId = response.getErrorStatus();
            if (errorStatusId != 0) {
                SETTER_LOG.warn("Response PDU when sending to host {} has error: {}", (Object)hostIp, (Object)SnmpSession.constructErrorMessage(response));
                this.checkErrorCodeAndDescription();
                if (16 == errorStatusId) {
                    String authErrorMsg = "Authorization error occurred; Please confirm that the device is running normally and verify the SNMP community strings.";
                    throw new SnmpIoException(hostIp, "Authorization error occurred; Please confirm that the device is running normally and verify the SNMP community strings.");
                }
                throw new SnmpIoException(hostIp, response.getErrorStatusText());
            }
        } else {
            SETTER_LOG.debug("Timed Out");
            throw new SnmpIoException(hostIp, "Timed out");
        }
        SETTER_LOG.debug("Success");
    }

    private static String constructErrorMessage(PDU response) {
        int bindingIndex = response.getErrorIndex() - 1;
        String error = "";
        if (bindingIndex > -1) {
            error = response.getVariableBindings().get(bindingIndex);
        }
        return response.getErrorStatusText() + SPACE + error;
    }

    @Override
    public void checkErrorCodeAndDescription() {
    }

    protected String getHostAddress() {
        return ((IpAddress)this.address).getInetAddress().getHostAddress();
    }

    private Variable getVariableValue(String oid) throws IOException {
        LOG.debug(">>> getVariableValue oid:{}", (Object)oid);
        PDU request = this.snmpConfiguration.createPDU(-96);
        request.add(new VariableBinding(new OID(oid)));
        ResponseEvent responseEvent = this.snmpInterface.send(request, this.target);
        if (responseEvent == null || responseEvent.getResponse() == null) {
            throw new IOException("No response from device. Please confirm that the device is running normally and verify the SNMP community strings.");
        }
        PDU response = responseEvent.getResponse();
        Variable var = response.get(0).getVariable();
        return var;
    }

    public PDU createPDU(Target target) {
        PDU request = this.snmpConfiguration.createPDU(-91);
        return request;
    }

    protected boolean isInvalid(String value) {
        return value == null || value.equals(NULL) || value.equals(NO_SUCH_OBJECT);
    }

    protected ISnmpTableWalker getTableWalker() {
        return this.tableWalker;
    }

    private class TreeResponseListener
    implements TreeListener {
        private final long startTime = System.currentTimeMillis();
        private final IVariableBindingHandler networkDevice;
        private final List<OID> oids;
        private final TreeUtils treeUtils;
        private boolean finished;
        private int requests;
        private int objects;
        private WalkResponse response;
        private int oidIndex;
        private OID lastProcessedOid;

        public TreeResponseListener(IVariableBindingHandler networkDevice, List<OID> oids, TreeUtils treeUtils) {
            this.networkDevice = networkDevice;
            this.oids = oids;
            this.treeUtils = treeUtils;
            this.oidIndex = 0;
            this.finished = false;
        }

        public WalkResponse getResponse() {
            return this.response == null ? new WalkResponse(new WalkException("Walk interrupted")) : this.response;
        }

        public void stopWalk() {
            this.finished = true;
        }

        public boolean next(TreeEvent e) {
            ++this.requests;
            VariableBinding[] vbs = e.getVariableBindings();
            for (int i = 0; i < vbs.length; ++i) {
                if (!this.addVariable(vbs, i)) continue;
                ++this.objects;
            }
            return !this.finished;
        }

        private boolean addVariable(VariableBinding[] vbs, int i) {
            try {
                VariableBinding binding = vbs[i];
                boolean wasAdded = this.networkDevice.addVariable(binding);
                if (!wasAdded) {
                    LOG.debug("Element {} unknown varbind: {}", (Object)SnmpSession.this.getHostAddress(), (Object)binding);
                    return false;
                }
                WALKER_LOG.debug("Element {} added varbind: {}.", (Object)SnmpSession.this.getHostAddress(), (Object)binding);
                this.lastProcessedOid = binding.getOid();
            }
            catch (RuntimeException e) {
                WALKER_LOG.warn("Failed adding varbind " + vbs[i] + " for element " + SnmpSession.this.getHostAddress() + ".", (Throwable)e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TreeEvent e) {
            if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                WALKER_LOG.debug("Element {} finished subtree count {}.", (Object)SnmpSession.this.getHostAddress(), (Object)e.getVariableBindings().length);
                this.next(e);
            }
            if (!this.finished && this.advanceOidIndex()) {
                return;
            }
            long walkTime = System.currentTimeMillis() - this.startTime;
            WALKER_LOG.debug("Element {} walked, requests: {}, objects: {} time: {}.", new Object[]{SnmpSession.this.getHostAddress(), this.requests, this.objects, walkTime});
            if (e.isError()) {
                LOG.error("Exception while walking " + SnmpSession.this.getHostAddress() + ".", (Throwable)e.getException());
                this.response = new WalkResponse(new WalkException(e.getErrorMessage()));
            } else {
                this.response = new WalkResponse(true);
                this.response.setObjectCount(this.objects);
                this.response.setRequestCount(this.requests);
                this.response.setWalkTime(walkTime);
            }
            this.finished = true;
            TreeResponseListener treeResponseListener = this;
            synchronized (treeResponseListener) {
                this.notify();
            }
        }

        public boolean isFinished() {
            WALKER_LOG.debug("Element {} finished: {}", (Object)SnmpSession.this.getHostAddress(), (Object)this.finished);
            return this.finished;
        }

        private boolean advanceOidIndex() {
            while (++this.oidIndex < this.oids.size() && this.lastProcessedOid != null && this.lastProcessedOid.compareTo((Variable)this.oids.get(this.oidIndex)) > 0) {
            }
            if (this.oidIndex < this.oids.size()) {
                WALKER_LOG.debug("Element {} next subtree: {}", (Object)SnmpSession.this.getHostAddress(), (Object)this.oids.get(this.oidIndex));
                this.treeUtils.getSubtree(SnmpSession.this.target, this.oids.get(this.oidIndex), (Object)this, (TreeListener)this);
                return true;
            }
            return false;
        }
    }
}

