/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import java.io.IOException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public abstract class SnmpConfiguration
implements ISnmpConfiguration {
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int DEFAULT_REPETITIONS = 10;
    private static final int DEFAULT_MAX_SIZE_RESPONSE_PDU = 65535;
    private static final int DEFAULT_WALK_TIMEOUT = 900000;
    private static final int DEFAULT_PORT = 161;
    private static final int DEFAULT_DISPATCHER_POOL_SIZE = 8;
    private static final int DEFAULT_MAX_ROWS_PER_PDU = 0;
    private static final int DEFAULT_MAX_COLUMNS_PER_PDU = 0;
    private int version;
    private int retries = 1;
    private int timeout = 1000;
    private int maxRepetitions = 10;
    private int nonRepeaters = 0;
    private int maxSizeResponsePDU = 65535;
    private int walkTimeout = 900000;
    private int port = 161;
    private int dispatcherPoolSize = 8;
    private int maximumRowsPerPdu = 0;
    private int maximumColumnsPerPdu = 0;
    private OctetString community = new OctetString("public");

    public int getDispatcherPoolSize() {
        return this.dispatcherPoolSize;
    }

    @Override
    public void setCommunity(String community) {
        this.community = new OctetString(community);
    }

    public void setDispatcherPoolSize(int dispatcherPoolSize) {
        this.dispatcherPoolSize = dispatcherPoolSize;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public int getMaxSizeResponsePDU() {
        return this.maxSizeResponsePDU;
    }

    public void setMaxSizeResponsePDU(int maxSizeResponsePDU) {
        this.maxSizeResponsePDU = maxSizeResponsePDU;
    }

    @Override
    public abstract Target createTarget(Address var1);

    @Override
    public abstract PDU createPDU(int var1);

    public abstract Snmp createSnmpSession(TransportMapping var1) throws IOException;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    @Override
    public int getWalkTimeout() {
        return this.walkTimeout;
    }

    public void setWalkTimeout(int walkTimeout) {
        this.walkTimeout = walkTimeout;
    }

    @Override
    public String getCommunity() {
        return this.community == null ? null : this.community.toString();
    }

    @Override
    public int getMaximumRowsPerPdu() {
        return this.maximumRowsPerPdu;
    }

    public void setMaximumRowsPerPdu(int maximumRowsPerPdu) {
        this.maximumRowsPerPdu = maximumRowsPerPdu;
    }

    @Override
    public int getMaximumColumnsPerPdu() {
        return this.maximumColumnsPerPdu;
    }

    public void setMaximumColumnsPerPdu(int maximumColumnsPerPdu) {
        this.maximumColumnsPerPdu = maximumColumnsPerPdu;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }
}

