/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.snmp;

import java.io.Serializable;
import java.util.Comparator;

public class OIDComparator
implements Serializable,
Comparator<String> {
    private static final int DIGIT_LOWER_BOUND = 48;
    private static final int DIGIT_UPPER_BOUND = 57;

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getChunk(String s, int slength, int marker) {
        int chunkMarker = marker;
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(chunkMarker);
        chunk.append(c);
        ++chunkMarker;
        if (this.isDigit(c)) {
            while (chunkMarker < slength && this.isDigit(c = s.charAt(chunkMarker))) {
                chunk.append(c);
                ++chunkMarker;
            }
        } else {
            while (chunkMarker < slength && !this.isDigit(c = s.charAt(chunkMarker))) {
                chunk.append(c);
                ++chunkMarker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(String o1, String o2) {
        String s1 = o1;
        String s2 = o2;
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            int result = 0;
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }
}

