/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import com.btisystems.pronx.ems.schemas.meta.notification.FieldDescription;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.snmp4j.smi.OID;

public class NotificationDescription {
    private final OID oid;
    private final TreeMap<String, FieldDescription> fieldsByName = new TreeMap();
    private final TreeMap<String, FieldDescription> fieldsByOid = new TreeMap();
    private final String name;
    private final String description;

    public NotificationDescription(OID oid, String name, String description, List<FieldDescription> fields) {
        this.oid = oid;
        this.name = name;
        this.description = description;
        if (fields != null) {
            for (FieldDescription field : fields) {
                this.addField(field);
            }
        }
    }

    private void addField(FieldDescription description) {
        this.fieldsByName.put(description.getName(), description);
        this.fieldsByOid.put(description.getOid(), description);
    }

    public OID getOid() {
        return this.oid;
    }

    public FieldDescription getFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    public FieldDescription getFieldByOid(String oid) {
        FieldDescription fieldDescription = this.fieldsByOid.get(oid);
        return fieldDescription;
    }

    public Collection<FieldDescription> getFields() {
        return this.fieldsByName.values();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

