/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import com.btisystems.pronx.ems.core.model.AbstractRootEntity;
import com.btisystems.pronx.ems.core.model.DeviceEntity;
import com.btisystems.pronx.ems.core.model.IClassRegistry;
import com.btisystems.pronx.ems.core.model.IIndexed;
import com.btisystems.pronx.ems.core.model.INetworkDevice;
import com.btisystems.pronx.ems.core.model.ITableAccess;
import com.btisystems.pronx.ems.core.model.IVariableBindingSetter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class NetworkDevice
implements INetworkDevice {
    private static Logger log = LoggerFactory.getLogger(NetworkDevice.class);
    private final IClassRegistry oidRegistry;
    private final Map<OID, DeviceEntity> simpleObjects = new HashMap<OID, DeviceEntity>();
    private AbstractRootEntity rootEntity;
    private final String deviceAddress;

    public NetworkDevice(IClassRegistry oidRegistry, String deviceAddress) {
        this.oidRegistry = oidRegistry;
        this.deviceAddress = deviceAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean addVariable(VariableBinding binding) {
        log.debug(">>> addVariable:{}", (Object)binding);
        OID containingOid = this.getContainingClassOid(binding.getOid());
        if (containingOid == null) {
            log.info("Ignoring oid {} from {}.", (Object)binding.getOid(), (Object)this.deviceAddress);
            return false;
        }
        int indexElementCount = binding.getOid().size() - containingOid.size();
        log.trace("indexElementCount:{}", (Object)indexElementCount);
        Class<? extends DeviceEntity> containingClass = this.oidRegistry.getClass(containingOid);
        if (IIndexed.class.isAssignableFrom(containingClass)) {
            this.addTableColumn(binding, containingOid, indexElementCount - 1);
            return true;
        }
        if (indexElementCount == 2) {
            this.addScalarVariable(binding, containingOid);
            return true;
        }
        log.debug("Unrecognised OID:" + binding.getOid());
        return false;
    }

    @Override
    public AbstractRootEntity getRootObject() {
        return this.getRootEntity();
    }

    private void addScalarVariable(VariableBinding binding, OID containingOid) {
        log.debug(">>> addScalarVariable:{} {}", (Object)binding, (Object)containingOid);
        DeviceEntity containingObject = this.getObject(containingOid);
        if (containingObject != null) {
            this.setVariable(containingObject, binding);
        } else {
            log.debug("Failed to find class for:{}", (Object)containingOid);
        }
    }

    private void addTableColumn(VariableBinding binding, OID entryOid, int indexElementCount) {
        log.debug(">>> addTableColumn:{} {}", (Object)binding, (Object)entryOid);
        String entryIdentifier = this.getTableEntryIdentifier(binding.getOid(), indexElementCount);
        log.debug("entryIdentifier:{}", (Object)entryIdentifier);
        Object tableEntry = this.getTableEntry(entryOid, binding.getOid(), entryIdentifier);
        if (tableEntry != null) {
            this.setVariable(tableEntry, binding);
        }
        log.debug("<<< addTableColumn");
    }

    private Object getTableEntry(OID entryOid, OID variableOid, String entryIdentifier) {
        Class<? extends DeviceEntity> clazz = this.oidRegistry.getClass(entryOid);
        if (clazz == null) {
            log.debug("Unrecognized table entry:{}", (Object)entryOid);
            return null;
        }
        DeviceEntity entity = this.getObject(this.getParentOid(entryOid));
        assert (entity != null) : "Failed to get table object";
        ITableAccess table = (ITableAccess)((Object)entity);
        Object entryObject = table.getEntry(entryIdentifier);
        if (entryObject != null) {
            return entryObject;
        }
        DeviceEntity newEntryObject = this.instantiateObject(clazz);
        if (newEntryObject != null) {
            table.setEntry(entryIdentifier, newEntryObject);
            ((IIndexed)((Object)newEntryObject))._setIndex(variableOid);
            return newEntryObject;
        }
        return null;
    }

    private void setVariable(Object parentObject, VariableBinding binding) {
        log.debug(">>> setVariable oid:{} object:{}", (Object)binding.getOid(), (Object)parentObject.getClass().getName());
        ((IVariableBindingSetter)parentObject).set(binding);
    }

    private DeviceEntity getObject(OID oid) {
        DeviceEntity object = this.simpleObjects.get(oid);
        if (object != null) {
            return object;
        }
        DeviceEntity newObject = this.createNewEntity(oid);
        return newObject;
    }

    private DeviceEntity createNewEntity(OID oid) {
        Class<? extends DeviceEntity> clazz = this.oidRegistry.getClass(oid);
        if (clazz == null) {
            log.debug("No class for oid:{}", (Object)oid);
            return null;
        }
        DeviceEntity object = this.instantiateObject(clazz);
        if (object != null) {
            this.simpleObjects.put(oid, object);
            AbstractRootEntity rootEntity = this.getRootEntity();
            rootEntity.setObject(object);
            return object;
        }
        return null;
    }

    private AbstractRootEntity getRootEntity() {
        log.debug(">>> getRootEntity");
        if (this.rootEntity == null) {
            Class<? extends AbstractRootEntity> rootEntityClass = this.oidRegistry.getRootEntityClass();
            try {
                log.debug("instantiating entity type:{}", rootEntityClass);
                this.rootEntity = rootEntityClass.newInstance();
                log.debug("set device address:{}", (Object)this.deviceAddress);
                this.rootEntity.setDeviceAddress(this.deviceAddress);
            }
            catch (Exception e) {
                log.debug("Failed to create root entity:", (Throwable)e);
                log.error("Failed to create root entity:{} {}", rootEntityClass, (Object)e.getMessage());
            }
        }
        return this.rootEntity;
    }

    private DeviceEntity instantiateObject(Class<? extends DeviceEntity> clazz) {
        DeviceEntity object = null;
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.warn("Failed to instantiate object of type a {} {}", clazz, (Object)e.getMessage());
            log.debug("Failed to instantiate object of type a {}:", clazz, (Object)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to instantiate object of type b {} {}", clazz, (Object)e.getMessage());
            log.debug("Failed to instantiate object of type b {}:", clazz, (Object)e);
        }
        return object;
    }

    private String getTableEntryIdentifier(OID oid, int length) {
        int startIndex;
        int[] rawOid = oid.getValue();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex = rawOid.length - length; i < rawOid.length; ++i) {
            if (i > startIndex) {
                sb.append('.');
            }
            sb.append(rawOid[i]);
        }
        return sb.toString();
    }

    private OID getParentOid(OID oid) {
        return this.getAncestorOid(oid, 1);
    }

    private OID getAncestorOid(OID oid, int generationCount) {
        int[] rawOid = oid.getValue();
        int levels = oid.size();
        if (levels <= generationCount) {
            log.debug("Unexpected OID Ancestor {} {}", (Object)oid, (Object)generationCount);
            return null;
        }
        return new OID(rawOid, 0, levels - generationCount);
    }

    private OID getContainingClassOid(OID oid) {
        OID parentOid = this.getParentOid(oid);
        while (parentOid != null && this.oidRegistry.getClass(parentOid) == null) {
            parentOid = this.getParentOid(parentOid);
        }
        log.trace("<<< getContainingClassOid {}", (Object)parentOid);
        return parentOid;
    }
}

