/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.smi.OID;

public class DeviceEntityDescription
implements Serializable {
    private final OID oid;
    private final Map<String, FieldDescription> fieldsByName = new TreeMap<String, FieldDescription>();
    private final Map<Integer, FieldDescription> fieldsById = new TreeMap<Integer, FieldDescription>();

    public DeviceEntityDescription(OID oid) {
        this.oid = oid;
    }

    public void addField(FieldDescription description) {
        this.fieldsByName.put(description.getName(), description);
        this.fieldsById.put(description.getId(), description);
    }

    public OID getOid() {
        return this.oid;
    }

    public FieldDescription getFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    public FieldDescription getFieldById(int id) {
        return this.fieldsById.get(id);
    }

    public Collection<FieldDescription> getFields() {
        return this.fieldsByName.values();
    }

    public static class FieldDescription
    implements Serializable {
        private final int id;
        private final String name;
        private final FieldType type;
        private final int maximumLength;

        public FieldDescription(int id, String name, FieldType type, int maximumLength) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.maximumLength = maximumLength;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public FieldType getType() {
            return this.type;
        }

        public int getMaximumLength() {
            return this.maximumLength;
        }

        public String toString() {
            return "FieldDescription{id=" + this.id + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", maximumLength=" + this.maximumLength + '}';
        }
    }

    public static enum FieldType {
        INTEGER,
        STRING,
        UNSIGNED32,
        UNSIGNED64,
        IP_ADDRESS,
        DATE_AND_TIME,
        BITS,
        TABLE,
        ENTITY,
        FIXED_X10,
        FIXED_X100,
        FIXED_X1000,
        OID;

    }
}

