/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import com.btisystems.pronx.ems.core.exception.FieldAccessMethodException;
import com.btisystems.pronx.ems.core.exception.InvalidFieldNameException;
import com.btisystems.pronx.ems.core.model.AbstractRootEntity;
import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.model.IDeviceEntity;
import com.btisystems.pronx.ems.core.model.ITableAccess;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeviceEntity
implements IDeviceEntity,
Serializable {
    public static final String EMPTY_STRING = "";
    public static final String DOT = ".";
    public static final String S_02X = "%s%02x";
    public static final String COLON = ":";
    private static final Logger LOG = LoggerFactory.getLogger(DeviceEntity.class);
    private transient Set<PropertyChangeListener> changeListeners = new HashSet<PropertyChangeListener>();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners = new HashSet<PropertyChangeListener>();
    }

    Collection<DeviceEntity> getChildren() {
        ArrayList<DeviceEntity> children = new ArrayList<DeviceEntity>();
        if (this.get_Description() != null) {
            this.addFields(children);
        }
        return children;
    }

    private void addFields(Collection<DeviceEntity> children) {
        for (DeviceEntityDescription.FieldDescription field : this.get_Description().getFields()) {
            this.addField(field, children);
        }
    }

    private void addField(DeviceEntityDescription.FieldDescription field, Collection<DeviceEntity> children) {
        if (field.getType() == DeviceEntityDescription.FieldType.ENTITY) {
            this.addEntity(field, children);
        } else if (field.getType() == DeviceEntityDescription.FieldType.TABLE) {
            this.addTable(children);
        }
    }

    private void addTable(Collection<DeviceEntity> children) {
        ITableAccess tableAccess = (ITableAccess)((Object)this);
        children.addAll(tableAccess.getEntries().values());
    }

    private void addEntity(DeviceEntityDescription.FieldDescription field, Collection<DeviceEntity> children) {
        Object obj = this.invokeGetter(field.getName());
        if (obj instanceof DeviceEntity) {
            children.add((DeviceEntity)obj);
        }
    }

    protected void addChild(IDeviceEntity child) {
        for (PropertyChangeListener listener : this.changeListeners) {
            child.addPropertyChangeListener(listener);
        }
    }

    protected void removeChild(DeviceEntity child) {
        for (PropertyChangeListener listener : this.changeListeners) {
            child.removePropertyChangeListener(listener);
        }
    }

    protected void replaceChild(DeviceEntity oldChild, DeviceEntity newChild) {
        if (oldChild != null) {
            this.removeChild(oldChild);
        }
        if (newChild != null) {
            this.addChild(newChild);
        }
    }

    protected void notifyChange(int fieldId, Object oldValue, Object newValue) {
        for (PropertyChangeListener listener : this.changeListeners) {
            listener.propertyChange(new PropertyChangeEvent(this, EMPTY_STRING + Integer.toString(fieldId), oldValue, newValue));
        }
    }

    protected String _getObjectIdentifier(int[] intArray, int offset, int length) {
        StringBuilder buffer = new StringBuilder();
        String sepChar = EMPTY_STRING;
        for (int x = 0; x < length; ++x) {
            buffer.append(sepChar).append(intArray[offset + x]);
            sepChar = DOT;
        }
        return buffer.toString();
    }

    protected String _getMacAddress(int[] intArray, int offset, int length) {
        StringBuilder buffer = new StringBuilder();
        String sepChar = EMPTY_STRING;
        for (int x = 0; x < length; ++x) {
            buffer.append(String.format(S_02X, sepChar, intArray[offset + x]));
            sepChar = COLON;
        }
        return buffer.toString();
    }

    public Object clone() {
        LOG.warn("clone not implemented for {}", (Object)this);
        return null;
    }

    public String toString() {
        return "DeviceEntity{changeListeners=" + this.changeListeners + ", get_Description()=" + this.get_Description() + '}';
    }

    @Override
    public abstract DeviceEntityDescription get_Description();

    @Override
    public String getString(String fieldName) {
        return (String)this.invokeGetter(fieldName);
    }

    @Override
    public int getInt(String fieldName) {
        return (Integer)this.invokeGetter(fieldName);
    }

    @Override
    public long getLong(String fieldName) {
        return (Long)this.invokeGetter(fieldName);
    }

    @Override
    public void set(String fieldName, String value) {
        this.invokeSetter(fieldName, value, String.class);
    }

    @Override
    public void set(String fieldName, int value) {
        this.invokeSetter(fieldName, value, Integer.TYPE);
    }

    @Override
    public void set(String fieldName, long value) {
        this.invokeSetter(fieldName, value, Long.TYPE);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.add(listener);
        for (DeviceEntity child : this.getChildren()) {
            child.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.remove(listener);
        for (DeviceEntity child : this.getChildren()) {
            child.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void clearPropertyChangeListeners() {
        this.changeListeners.clear();
        for (DeviceEntity child : this.getChildren()) {
            child.clearPropertyChangeListeners();
        }
    }

    @Override
    public void set_ParentEntity(AbstractRootEntity parent) {
    }

    @Override
    public boolean isSupported(String fieldName) {
        DeviceEntityDescription description = this.get_Description();
        return description.getFieldByName(fieldName) != null;
    }

    private void invokeSetter(String fieldName, Object value, Class type) {
        try {
            Method method = this.getClass().getMethod(this.getSetterName(fieldName), type);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Exception on getMethod", (Throwable)e);
            throw new InvalidFieldNameException(this, fieldName);
        }
        catch (Exception e) {
            LOG.warn("Exception on set", (Throwable)e);
            throw new FieldAccessMethodException(this, fieldName, e.getMessage());
        }
    }

    protected String getSetterName(String field) throws Exception {
        return "set" + this.capitalizeFirstCharacter(field);
    }

    private Object invokeGetter(String fieldName) {
        try {
            Method method = this.getClass().getMethod(this.getGetterName(fieldName), new Class[0]);
            return method.invoke((Object)this, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Exception on getMethod", (Throwable)e);
            throw new InvalidFieldNameException(this, fieldName);
        }
        catch (Exception e) {
            LOG.warn("Exception on get", (Throwable)e);
            throw new FieldAccessMethodException(this, fieldName, e.getMessage());
        }
    }

    protected String getGetterName(String field) {
        return "get" + this.capitalizeFirstCharacter(field);
    }

    private String capitalizeFirstCharacter(String name) {
        StringBuilder sb = new StringBuilder(name);
        char firstChar = sb.charAt(0);
        sb.setCharAt(0, Character.toUpperCase(firstChar));
        return sb.toString();
    }

    Set<PropertyChangeListener> _getChangeListeners() {
        return this.changeListeners;
    }
}

