/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import com.btisystems.pronx.ems.core.model.AbstractRootEntity;
import com.btisystems.pronx.ems.core.model.DeviceEntity;
import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.model.IClassRegistry;
import com.btisystems.pronx.ems.core.model.IIndexed;
import com.btisystems.pronx.ems.core.model.ITableAccess;
import com.btisystems.pronx.ems.core.model.IVariableBindingSetter;
import com.btisystems.pronx.ems.core.snmp.OIDComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;

public class ClassRegistry
implements IClassRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ClassRegistry.class);
    private static final long serialVersionUID = 1L;
    private final TreeMap<OID, Class<? extends DeviceEntity>> oidToClassMap;
    private final HashMap<String, Class<? extends DeviceEntity>> nameToClassMap;
    private final Class<? extends AbstractRootEntity> rootEntityClass;
    private List<OID> excludedDiscoveryOids = new ArrayList<OID>();
    private final Map<Class<? extends DeviceEntity>, OID> classToOidMap;

    public ClassRegistry(TreeMap<OID, Class<? extends DeviceEntity>> oidRegistry, Class<? extends AbstractRootEntity> rootEntityClass) {
        LOG.debug(">>> ClassRegistry");
        this.oidToClassMap = oidRegistry;
        this.rootEntityClass = rootEntityClass;
        this.classToOidMap = this.createClassToOidMap(oidRegistry);
        this.nameToClassMap = this.createNameToClassMap(oidRegistry);
    }

    @Override
    public Class<? extends AbstractRootEntity> getRootEntityClass() {
        return this.rootEntityClass;
    }

    @Override
    public Class<? extends DeviceEntity> getClass(OID oid) {
        return this.oidToClassMap.get(oid);
    }

    @Override
    public Class<? extends DeviceEntity> getClass(String name) {
        return this.nameToClassMap.get(name);
    }

    @Override
    public List<OID> getOids() {
        return new ArrayList<OID>(this.oidToClassMap.keySet());
    }

    @Override
    public List<OID> getDiscoveryOids() {
        List<OID> oids = new ArrayList<OID>();
        for (Map.Entry<OID, Class<? extends DeviceEntity>> entry : this.oidToClassMap.entrySet()) {
            if (IIndexed.class.isAssignableFrom(entry.getValue())) continue;
            oids.add(entry.getKey());
        }
        oids = this.processExcludedOIDs(oids);
        LOG.trace("Returning discovery oids: {}", oids);
        return oids;
    }

    @Override
    public Map<Class<? extends DeviceEntity>, OID> getClassToOidMap() {
        return this.classToOidMap;
    }

    private List<OID> processExcludedOIDs(List<OID> oids) {
        LOG.debug("Excluding oids from discovery list: {}", this.excludedDiscoveryOids);
        for (OID excludedOid : this.excludedDiscoveryOids) {
            ArrayList<OID> oidsToRemove = new ArrayList<OID>();
            ArrayList<OID> oidsToAdd = new ArrayList<OID>();
            for (OID discoveryOid : oids) {
                OID excludedBranch;
                if (discoveryOid.toString().startsWith(excludedOid.toString())) {
                    oidsToRemove.add(discoveryOid);
                }
                if (!discoveryOid.equals((Object)(excludedBranch = new OID(excludedOid).trim()))) continue;
                oidsToRemove.add(discoveryOid);
                this.reAddScalars(excludedBranch, oidsToAdd);
            }
            for (OID oid : oidsToAdd) {
                if (oids.contains(oid)) continue;
                oids.add(oid);
            }
            oids.removeAll(oidsToRemove);
        }
        this.sortOids(oids);
        return oids;
    }

    private void sortOids(List<OID> oids) {
        Collections.sort(oids, new Comparator<OID>(){
            private final OIDComparator alphaNumComparator = new OIDComparator();

            @Override
            public int compare(OID o1, OID o2) {
                return this.alphaNumComparator.compare(o1.toString(), o2.toString());
            }
        });
    }

    private void reAddScalars(OID excludedBranch, List<OID> oidsToAdd) {
        Class<? extends DeviceEntity> excludedClazz = this.oidToClassMap.get(excludedBranch);
        try {
            if (excludedClazz != null) {
                DeviceEntity excludedEntity = excludedClazz.newInstance();
                for (DeviceEntityDescription.FieldDescription fieldDescription : excludedEntity.get_Description().getFields()) {
                    oidsToAdd.add(new OID(excludedEntity.get_Description().getOid()).append(fieldDescription.getId()));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error adding scalar attributes back in for excluded branch: {}", (Object)excludedBranch, (Object)ex);
        }
    }

    @Override
    public void setExcludedDiscoveryOids(String oids) {
        if (oids != null) {
            ArrayList<OID> oidList = new ArrayList<OID>();
            for (String oid : oids.split(",")) {
                oidList.add(new OID(oid));
            }
            this.excludedDiscoveryOids = oidList;
        }
    }

    private HashMap<String, Class<? extends DeviceEntity>> createNameToClassMap(TreeMap<OID, Class<? extends DeviceEntity>> oidRegistry) {
        HashMap<String, Class<? extends DeviceEntity>> newNameToClassMap = new HashMap<String, Class<? extends DeviceEntity>>();
        for (Class<? extends DeviceEntity> entityClass : oidRegistry.values()) {
            newNameToClassMap.put(entityClass.getSimpleName(), entityClass);
        }
        return newNameToClassMap;
    }

    private HashMap<Class<? extends DeviceEntity>, OID> createClassToOidMap(TreeMap<OID, Class<? extends DeviceEntity>> oidRegistry) {
        HashMap<Class<? extends DeviceEntity>, OID> newClassToOidMap = new HashMap<Class<? extends DeviceEntity>, OID>();
        for (Map.Entry<OID, Class<? extends DeviceEntity>> entrySet : oidRegistry.entrySet()) {
            newClassToOidMap.put(entrySet.getValue(), entrySet.getKey());
        }
        return newClassToOidMap;
    }

    @Override
    public DeviceEntityDescription getEntityDescription(OID oid) {
        Class<? extends DeviceEntity> entityClazz = this.oidToClassMap.get(oid);
        try {
            if (entityClazz != null) {
                DeviceEntity entity = entityClazz.newInstance();
                return entity.get_Description();
            }
        }
        catch (Exception ex) {
            LOG.error("Error retrieving entity description : {}", (Object)oid, (Object)ex);
        }
        return null;
    }

    @Override
    public Class<? extends DeviceEntity> getContainingEntityClass(String oidValue) {
        LOG.debug("oid={}", (Object)oidValue);
        OID baseOid = new OID(oidValue);
        Class<? extends DeviceEntity> childClass = this.getClass(baseOid);
        LOG.debug("child class={}", childClass);
        baseOid.trim(1);
        Class<? extends DeviceEntity> parentClass = this.getClass(baseOid);
        LOG.debug("parent class={}", parentClass);
        if (parentClass != null && (this.isClassForAMibTable(parentClass) || this.isClassForAVarBindsSetter(parentClass))) {
            return parentClass;
        }
        return childClass;
    }

    private boolean isClassForAMibTable(Class<? extends DeviceEntity> clazz) {
        return ITableAccess.class.isAssignableFrom(clazz);
    }

    private boolean isClassForAVarBindsSetter(Class<? extends DeviceEntity> clazz) {
        return IVariableBindingSetter.class.isAssignableFrom(clazz);
    }
}

