/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.model;

import com.btisystems.pronx.ems.core.exception.FieldAccessMethodException;
import com.btisystems.pronx.ems.core.exception.InvalidFieldNameException;
import com.btisystems.pronx.ems.core.model.DeviceEntity;
import com.btisystems.pronx.ems.core.model.DeviceEntityDescription;
import com.btisystems.pronx.ems.core.model.IObjectSetter;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;

public abstract class AbstractRootEntity
extends DeviceEntity
implements IObjectSetter {
    private static Logger log = LoggerFactory.getLogger(AbstractRootEntity.class);
    private int id;
    private String deviceAddress;

    public int getId() {
        return this.id;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public boolean isEntitySupported(String fieldName) {
        boolean result = true;
        try {
            this.getClass().getMethod(this.getGetterName(fieldName), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            log.trace("No such field on class {}: {}", new Object[]{this.getClass().getName(), fieldName, ex});
            result = false;
        }
        return result;
    }

    public DeviceEntity getEntity(OID oid) {
        for (DeviceEntity root : this.getRoots()) {
            if (root == null || root.get_Description() == null || !oid.equals((Object)root.get_Description().getOid())) continue;
            return root;
        }
        return null;
    }

    public abstract DeviceEntity[] getRoots();

    public DeviceEntity getEntity(String fieldName) {
        try {
            Method method = this.getClass().getMethod(this.getGetterName(fieldName), new Class[0]);
            return (DeviceEntity)method.invoke((Object)this, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            log.warn("Unrecognised field name:{}", (Object)fieldName);
            log.trace("Exception:", (Throwable)e);
            throw new InvalidFieldNameException(this, fieldName);
        }
        catch (Exception e) {
            log.warn("Exception on get", (Throwable)e);
            throw new FieldAccessMethodException(this, fieldName, e.getMessage());
        }
    }

    @Override
    public DeviceEntityDescription get_Description() {
        return null;
    }

    public void setObject(Class clazz, Object childObject) {
        String sn = null;
        try {
            sn = clazz.getSimpleName();
            Method method = this.getClass().getMethod(this.getSetterName(sn), clazz);
            method.invoke((Object)this, childObject);
            if (childObject != null) {
                ((DeviceEntity)childObject).set_ParentEntity(this);
            }
        }
        catch (NoSuchMethodException e) {
            log.warn("No such method in setObject. SimpleName:" + sn, (Throwable)e);
            throw new InvalidFieldNameException(this, clazz.getSimpleName());
        }
        catch (Exception e) {
            log.warn("Exception in setObject. SimpleName:" + sn, (Throwable)e);
            throw new FieldAccessMethodException(this, sn, e.getMessage());
        }
    }

    public Object getObject(Class clazz) {
        String sn = null;
        try {
            sn = clazz.getSimpleName();
            Method method = this.getClass().getMethod(this.getGetterName(sn), new Class[0]);
            Object obj = method.invoke((Object)this, new Object[0]);
            return obj;
        }
        catch (NoSuchMethodException e) {
            log.warn("No such method in getObject. SimpleName:" + clazz.getSimpleName(), (Throwable)e);
            throw new InvalidFieldNameException(this, clazz.getSimpleName());
        }
        catch (Exception e) {
            log.warn("Exception in setObject. SimpleName:" + sn, (Throwable)e);
            throw new FieldAccessMethodException(this, sn, e.getMessage());
        }
    }

    @Override
    public void setObject(Object childObject) {
        this.setObject(childObject.getClass(), childObject);
    }

    public DeviceEntity createEntity(String entityName) {
        Class<? extends DeviceEntity> clazz = this.getEntityType(entityName);
        DeviceEntity entity = this.instantiateObject(clazz);
        this.setObject(clazz, (Object)entity);
        return entity;
    }

    private Class<? extends DeviceEntity> getEntityType(String entityName) {
        try {
            return this.getClass().getMethod(this.getGetterName(entityName), new Class[0]).getReturnType();
        }
        catch (SecurityException e) {
            log.warn("SecurityException on getEntityType", (Throwable)e);
            throw new FieldAccessMethodException(this, entityName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.warn("Exception on getEntityType", (Throwable)e);
            throw new InvalidFieldNameException(this, entityName);
        }
    }

    private DeviceEntity instantiateObject(Class<? extends DeviceEntity> clazz) {
        DeviceEntity object = null;
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.warn("Failed to instantiate object of type: " + clazz, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to access object of type : " + clazz, (Throwable)e);
        }
        return object;
    }
}

