/*
 * Decompiled with CFR 0.152.
 */
package com.btisystems.pronx.ems.core.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DetailedFaultException
extends RuntimeException {
    private static final long serialVersionUID = 3666677767195443650L;
    private static final Logger logger = LoggerFactory.getLogger(DetailedFaultException.class);
    private final String text;
    private final String[] variables;

    public DetailedFaultException(String text, String ... variables) {
        super(DetailedFaultException.format(text, variables));
        this.text = text;
        this.variables = variables;
        logger.error(DetailedFaultException.format(text, variables));
    }

    private static String format(String text, String ... variables) {
        return String.format(text, variables);
    }

    public DetailedFaultException(Throwable cause, String text, String ... variables) {
        super(DetailedFaultException.format(text, variables), cause);
        this.text = text;
        this.variables = variables;
        if (logger.isErrorEnabled()) {
            logger.error(DetailedFaultException.format(text, variables), cause);
        }
    }

    public String getText() {
        return this.text;
    }

    public String[] getVariables() {
        return this.variables;
    }
}

