/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.juniper;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.onosproject.drivers.juniper.JuniperUtils;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.behaviour.LinkDiscovery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class LinkDiscoveryJuniperImpl
extends AbstractHandlerBehaviour
implements LinkDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Set<LinkDescription> getLinks() {
        String reply;
        DeviceId localDeviceId = this.handler().data().deviceId();
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(localDeviceId)).getSession();
        try {
            reply = session.get(JuniperUtils.requestBuilder("<get-lldp-neighbors-information/>"));
        }
        catch (IOException e) {
            this.log.warn("Failed to retrieve ports for device {}", (Object)localDeviceId);
            return ImmutableSet.of();
        }
        this.log.debug("Reply from device {} : {}", (Object)localDeviceId, (Object)reply);
        Set<JuniperUtils.LinkAbstraction> linkAbstractions = JuniperUtils.parseJuniperLldp(XmlConfigParser.loadXmlString((String)reply));
        this.log.debug("Set of LinkAbstraction discovered {}", linkAbstractions);
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        HashSet<LinkDescription> descriptions = new HashSet<LinkDescription>();
        for (JuniperUtils.LinkAbstraction linkAbs : linkAbstractions) {
            Optional<Port> localPort = deviceService.getPorts(localDeviceId).stream().filter(port -> linkAbs.localPortName.equals(port.annotations().value("portName"))).findAny();
            if (!localPort.isPresent()) {
                this.log.warn("Port name {} does not exist in device {}", (Object)linkAbs.localPortName, (Object)localDeviceId);
                continue;
            }
            com.google.common.base.Optional dev = Iterables.tryFind((Iterable)deviceService.getAvailableDevices(), input -> input.chassisId().equals((Object)linkAbs.remoteChassisId));
            if (!dev.isPresent()) {
                this.log.warn("Device with chassis ID {} does not exist", (Object)linkAbs.remoteChassisId);
                continue;
            }
            Device remoteDevice = (Device)dev.get();
            Optional<Port> remotePort = deviceService.getPorts(remoteDevice.id()).stream().filter(port -> port.number().toLong() == linkAbs.remotePortIndex).findAny();
            if (!remotePort.isPresent()) {
                this.log.warn("Port number {} does not exist in device {}", (Object)linkAbs.remotePortIndex, (Object)remoteDevice.id());
                continue;
            }
            JuniperUtils.createBiDirLinkDescription(localDeviceId, localPort.get(), remoteDevice.id(), remotePort.get(), descriptions);
        }
        return descriptions;
    }
}

