/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.juniper;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.onlab.packet.ChassisId;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JuniperUtils {
    private static final Logger log = LoggerFactory.getLogger(JuniperUtils.class);
    public static final String FAILED_CFG = "Failed to retrieve configuration.";
    private static final String RPC_TAG_NETCONF_BASE = "<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">";
    private static final String RPC_CLOSE_TAG = "</rpc>";
    public static final String REQ_LLDP_NBR_INFO = "<get-lldp-neighbors-information/>";
    public static final String REQ_SYS_INFO = "<get-system-information/>";
    public static final String REQ_MAC_ADD_INFO = "<get-chassis-mac-addresses/>";
    public static final String REQ_IF_INFO = "<get-interface-information/>";
    private static final String LLDP_LIST_NBR_INFO = "lldp-neighbors-information";
    private static final String LLDP_NBR_INFO = "lldp-neighbor-information";
    private static final String SYS_INFO = "system-information";
    private static final String HW_MODEL = "hardware-model";
    private static final String OS_NAME = "os-name";
    private static final String OS_VER = "os-version";
    private static final String SER_NUM = "serial-number";
    private static final String IF_INFO = "interface-information";
    private static final String IF_PHY = "physical-interface";
    private static final String IF_TYPE = "if-type";
    private static final String SPEED = "speed";
    private static final String NAME = "name";
    private static final String SNMP_INDEX = "snmp-index";
    private static final String LLDP_LO_PORT = "lldp-local-port-id";
    private static final String LLDP_REM_CHASS = "lldp-remote-chassis-id";
    private static final String LLDP_REM_PORT = "lldp-remote-port-id";
    private static final String REGEX_ADD = ".*Private base address\\s*([:,0-9,a-f,A-F]*).*";
    private static final Pattern ADD_PATTERN = Pattern.compile(".*Private base address\\s*([:,0-9,a-f,A-F]*).*", 32);
    private static final String JUNIPER = "JUNIPER";
    private static final String UNKNOWN = "UNKNOWN";
    static final String AK_IF_TYPE = "ifType";
    static final String AK_ENCAPSULATION = "encapsulation";
    static final String AK_DESCRIPTION = "description";
    static final String AK_ADMIN_STATUS = "adminStatus";
    static final String AK_OPER_STATUS = "operStatus";
    static final String AK_PHYSICAL_PORT_NAME = "physicalPortName";
    private static final String NUMERIC_SPEED_REGEXP = "(\\d+)([GM])bps";
    private static final Pattern SPEED_PATTERN = Pattern.compile("(\\d+)([GM])bps", 2);
    private static final long DEFAULT_PORT_SPEED = 1000L;

    private JuniperUtils() {
    }

    public static String requestBuilder(String request) {
        return RPC_TAG_NETCONF_BASE + request + RPC_CLOSE_TAG;
    }

    public static DeviceDescription parseJuniperDescription(DeviceId deviceId, HierarchicalConfiguration sysInfoCfg, String chassisText) {
        SubnodeConfiguration info = sysInfoCfg.configurationAt(SYS_INFO);
        String hw = info.getString(HW_MODEL) == null ? UNKNOWN : info.getString(HW_MODEL);
        String sw = UNKNOWN;
        if (info.getString(OS_NAME) != null || info.getString(OS_VER) != null) {
            sw = info.getString(OS_NAME) + " " + info.getString(OS_VER);
        }
        String serial = info.getString(SER_NUM) == null ? UNKNOWN : info.getString(SER_NUM);
        Matcher matcher = ADD_PATTERN.matcher(chassisText);
        if (matcher.lookingAt()) {
            String chassis = matcher.group(1);
            MacAddress chassisMac = MacAddress.valueOf((String)chassis);
            return new DefaultDeviceDescription(deviceId.uri(), Device.Type.ROUTER, JUNIPER, hw, sw, serial, new ChassisId(chassisMac.toLong()), new SparseAnnotations[]{DefaultAnnotations.EMPTY});
        }
        return new DefaultDeviceDescription(deviceId.uri(), Device.Type.ROUTER, JUNIPER, hw, sw, serial, null, new SparseAnnotations[]{DefaultAnnotations.EMPTY});
    }

    public static List<PortDescription> parseJuniperPorts(HierarchicalConfiguration cfg) {
        ArrayList<PortDescription> portDescriptions = new ArrayList<PortDescription>();
        List subtrees = cfg.configurationsAt(IF_INFO);
        for (HierarchicalConfiguration interfInfo : subtrees) {
            List interfaceTree = interfInfo.configurationsAt(IF_PHY);
            for (HierarchicalConfiguration phyIntf : interfaceTree) {
                if (phyIntf == null) continue;
                JuniperUtils.parsePhysicalInterface(portDescriptions, phyIntf);
            }
        }
        return portDescriptions;
    }

    private static void parsePhysicalInterface(List<PortDescription> portDescriptions, HierarchicalConfiguration phyIntf) {
        DefaultAnnotations.Builder annotations = DefaultAnnotations.builder();
        PortNumber portNumber = PortNumber.portNumber((String)phyIntf.getString(SNMP_INDEX));
        String phyPortName = phyIntf.getString(NAME);
        if (portNumber == null) {
            log.debug("Skipping physical-interface {}, no PortNumer", (Object)phyPortName);
            log.trace("  {}", (Object)phyIntf);
            return;
        }
        JuniperUtils.setIfNonNull(annotations, "portName", phyPortName);
        JuniperUtils.setIfNonNull(annotations, "portMac", phyIntf.getString("current-physical-address"));
        JuniperUtils.setIfNonNull(annotations, AK_IF_TYPE, phyIntf.getString(IF_TYPE));
        JuniperUtils.setIfNonNull(annotations, AK_DESCRIPTION, phyIntf.getString(AK_DESCRIPTION));
        boolean opUp = phyIntf.getString(AK_OPER_STATUS, "down").equals("up");
        annotations.set("oper-status", JuniperUtils.toUpDown(opUp));
        boolean admUp = phyIntf.getString(AK_ADMIN_STATUS, "down").equals("up");
        annotations.set("admin-status", JuniperUtils.toUpDown(admUp));
        long portSpeed = JuniperUtils.toMbps(phyIntf.getString(SPEED));
        portDescriptions.add((PortDescription)new DefaultPortDescription(portNumber, admUp & opUp, Port.Type.COPPER, portSpeed, new SparseAnnotations[]{annotations.build()}));
        for (HierarchicalConfiguration logIntf : phyIntf.configurationsAt("logical-interface")) {
            if (logIntf == null) continue;
            PortNumber lPortNumber = JuniperUtils.safePortNumber(logIntf.getString(SNMP_INDEX));
            if (lPortNumber == null) {
                log.debug("Skipping logical-interface {} under {}, no PortNumer", (Object)logIntf.getString(NAME), (Object)phyPortName);
                log.trace("  {}", (Object)logIntf);
                continue;
            }
            DefaultAnnotations.Builder lannotations = DefaultAnnotations.builder();
            JuniperUtils.setIfNonNull(lannotations, "portName", logIntf.getString(NAME));
            JuniperUtils.setIfNonNull(lannotations, AK_PHYSICAL_PORT_NAME, phyPortName);
            String afName = logIntf.getString("address-family.address-family-name");
            String address = logIntf.getString("address-family.interface-address.ifa-local");
            if (afName != null && address != null) {
                JuniperUtils.setIfNonNull(lannotations, afName, address);
            }
            JuniperUtils.setIfNonNull(lannotations, "ip", logIntf.getString("address-family.interface-address.ifa-local"));
            JuniperUtils.setIfNonNull(lannotations, AK_ENCAPSULATION, logIntf.getString(AK_ENCAPSULATION));
            boolean lEnabled = logIntf.getString("if-config-flags.iff-up") != null;
            portDescriptions.add((PortDescription)new DefaultPortDescription(lPortNumber, admUp & opUp & lEnabled, Port.Type.COPPER, portSpeed, new SparseAnnotations[]{lannotations.build()}));
        }
    }

    static String toUpDown(boolean portStatus) {
        return portStatus ? "up" : "down";
    }

    static long toMbps(String speed) {
        String s = Strings.nullToEmpty((String)speed).trim().toLowerCase();
        Matcher matcher = SPEED_PATTERN.matcher(s);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            if ("m".equalsIgnoreCase(unit)) {
                return n;
            }
            return 1000 * n;
        }
        log.trace("Treating unknown speed value {} as default", (Object)speed);
        return 1000L;
    }

    static void setIfNonNull(DefaultAnnotations.Builder builder, String key, String value) {
        if (value != null) {
            builder.set(key, value.trim());
        }
    }

    static PortNumber safePortNumber(String s) {
        try {
            return PortNumber.portNumber((String)s);
        }
        catch (RuntimeException e) {
            log.trace("Failed parsing PortNumber {}", (Object)s, (Object)e);
            return null;
        }
    }

    public static void createBiDirLinkDescription(DeviceId localDevId, Port localPort, DeviceId remoteDevId, Port remotePort, Set<LinkDescription> descs) {
        ConnectPoint local = new ConnectPoint((ElementId)localDevId, localPort.number());
        ConnectPoint remote = new ConnectPoint((ElementId)remoteDevId, remotePort.number());
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("layer", "IP").build();
        descs.add((LinkDescription)new DefaultLinkDescription(local, remote, Link.Type.INDIRECT, false, new SparseAnnotations[]{annotations}));
        descs.add((LinkDescription)new DefaultLinkDescription(remote, local, Link.Type.INDIRECT, false, new SparseAnnotations[]{annotations}));
    }

    public static Set<LinkAbstraction> parseJuniperLldp(HierarchicalConfiguration info) {
        HashSet<LinkAbstraction> neighbour = new HashSet<LinkAbstraction>();
        List subtrees = info.configurationsAt(LLDP_LIST_NBR_INFO);
        for (HierarchicalConfiguration neighborsInfo : subtrees) {
            List neighbors = neighborsInfo.configurationsAt(LLDP_NBR_INFO);
            for (HierarchicalConfiguration neighbor : neighbors) {
                String localPortName = neighbor.getString(LLDP_LO_PORT);
                MacAddress mac = MacAddress.valueOf((String)neighbor.getString(LLDP_REM_CHASS));
                long remotePortIndex = neighbor.getInt(LLDP_REM_PORT);
                LinkAbstraction link = new LinkAbstraction(localPortName, mac.toLong(), remotePortIndex);
                neighbour.add(link);
            }
        }
        return neighbour;
    }

    protected static final class LinkAbstraction {
        protected String localPortName;
        protected ChassisId remoteChassisId;
        protected long remotePortIndex;

        protected LinkAbstraction(String pName, long chassisId, long pIndex) {
            this.localPortName = pName;
            this.remoteChassisId = new ChassisId(chassisId);
            this.remotePortIndex = pIndex;
        }
    }
}

