/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.juniper;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.onosproject.drivers.juniper.JuniperUtils;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DeviceDiscoveryJuniperImpl
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DeviceDescription discoverDeviceDetails() {
        String chassis;
        String sysInfo;
        DeviceId devId = this.handler().data().deviceId();
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(devId)).getSession();
        try {
            sysInfo = session.get(JuniperUtils.requestBuilder("<get-system-information/>"));
            chassis = session.get(JuniperUtils.requestBuilder("<get-chassis-mac-addresses/>"));
        }
        catch (IOException e) {
            this.log.warn("Failed to retrieve device details for {}", (Object)devId);
            return null;
        }
        this.log.trace("Device {} system-information {}", (Object)devId, (Object)sysInfo);
        DeviceDescription description = JuniperUtils.parseJuniperDescription(devId, XmlConfigParser.loadXmlString((String)sysInfo), chassis);
        this.log.debug("Device {} description {}", (Object)devId, (Object)description);
        return description;
    }

    public List<PortDescription> discoverPortDetails() {
        String reply;
        DeviceId devId = this.handler().data().deviceId();
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(devId)).getSession();
        try {
            reply = session.get(JuniperUtils.requestBuilder("<get-interface-information/>"));
        }
        catch (IOException e) {
            this.log.warn("Failed to retrieve ports for device {}", (Object)devId);
            return ImmutableList.of();
        }
        this.log.trace("Device {} interface-information {}", (Object)devId, (Object)reply);
        List<PortDescription> descriptions = JuniperUtils.parseJuniperPorts(XmlConfigParser.loadXmlString((String)reply));
        this.log.debug("Device {} Discovered ports {}", (Object)devId, descriptions);
        return descriptions;
    }
}

