/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class TrafficEngineeringMetric
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private long trafficEngineeringMetric;

    public TrafficEngineeringMetric(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public void setTrafficEngineeringMetric(long trafficEngineeringMetric) {
        this.trafficEngineeringMetric = trafficEngineeringMetric;
    }

    public long getTrafficEngineeringMetricValue() {
        return this.trafficEngineeringMetric;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        byte[] tempByteArray = new byte[this.tlvLength()];
        channelBuffer.readBytes(tempByteArray, 0, this.tlvLength());
        this.setTrafficEngineeringMetric(IsisUtil.byteToLong(tempByteArray));
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        byte[] linkSubTypeBody = IsisUtil.convertToFourBytes(this.trafficEngineeringMetric);
        return linkSubTypeBody;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("trafficEngineeringMetric", this.trafficEngineeringMetric).toString();
    }
}

