/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.InterfaceIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.NeighborIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvType;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;

public final class SubTlvFinder {
    private SubTlvFinder() {
    }

    public static TrafficEngineeringSubTlv findSubTlv(TlvHeader tlvHeader, ChannelBuffer channelBuffer) {
        TlvHeader subTlv = null;
        switch (SubTlvType.get(tlvHeader.tlvType())) {
            case ADMINISTRATIVEGROUP: {
                AdministrativeGroup administrativeGroup = new AdministrativeGroup(tlvHeader);
                administrativeGroup.readFrom(channelBuffer);
                subTlv = administrativeGroup;
                break;
            }
            case MAXIMUMBANDWIDTH: {
                MaximumBandwidth maximumBandwidth = new MaximumBandwidth(tlvHeader);
                maximumBandwidth.readFrom(channelBuffer);
                subTlv = maximumBandwidth;
                break;
            }
            case MAXIMUMRESERVABLEBANDWIDTH: {
                MaximumReservableBandwidth maxResBandwidth = new MaximumReservableBandwidth(tlvHeader);
                maxResBandwidth.readFrom(channelBuffer);
                subTlv = maxResBandwidth;
                break;
            }
            case TRAFFICENGINEERINGMETRIC: {
                TrafficEngineeringMetric teMetric = new TrafficEngineeringMetric(tlvHeader);
                teMetric.readFrom(channelBuffer);
                subTlv = teMetric;
                break;
            }
            case UNRESERVEDBANDWIDTH: {
                UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth(tlvHeader);
                unreservedBandwidth.readFrom(channelBuffer);
                subTlv = unreservedBandwidth;
                break;
            }
            case INTERFACEADDRESS: {
                InterfaceIpAddress ipInterfaceAddressTlv = new InterfaceIpAddress(tlvHeader);
                ipInterfaceAddressTlv.readFrom(channelBuffer);
                subTlv = ipInterfaceAddressTlv;
                break;
            }
            case NEIGHBORADDRESS: {
                NeighborIpAddress ipNeighborAddressTlv = new NeighborIpAddress(tlvHeader);
                ipNeighborAddressTlv.readFrom(channelBuffer);
                subTlv = ipNeighborAddressTlv;
                break;
            }
        }
        return subTlv;
    }
}

