/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborIpAddress
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private static final Logger log = LoggerFactory.getLogger(NeighborIpAddress.class);
    private Ip4Address neighborIPAddress;

    public NeighborIpAddress(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public void setIpAddress(Ip4Address neighborIPAddress) {
        this.neighborIPAddress = neighborIPAddress;
    }

    public Ip4Address neighborIPAddress() {
        return this.neighborIPAddress;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 4) {
            byte[] tempByteArray = new byte[4];
            channelBuffer.readBytes(tempByteArray, 0, 4);
            this.setIpAddress(Ip4Address.valueOf((byte[])tempByteArray));
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        ArrayList linkSubTypeBody = new ArrayList();
        linkSubTypeBody.addAll(Bytes.asList((byte[])this.neighborIPAddress.toOctets()));
        return Bytes.toArray(linkSubTypeBody);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeighborIpAddress that = (NeighborIpAddress)o;
        return Objects.equal((Object)this.neighborIPAddress, (Object)that.neighborIPAddress);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.neighborIPAddress});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("localInterfaceIPAddress", (Object)this.neighborIPAddress).toString();
    }
}

