/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class MaximumReservableBandwidth
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private float maximumReservableBandwidth;

    public MaximumReservableBandwidth(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public void setMaximumBandwidth(float maximumBandwidth) {
        this.maximumReservableBandwidth = maximumBandwidth;
    }

    public float getMaximumBandwidthValue() {
        return this.maximumReservableBandwidth;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        byte[] tempByteArray = new byte[this.tlvLength()];
        channelBuffer.readBytes(tempByteArray, 0, this.tlvLength());
        int maxBandwidth = IsisUtil.byteToInteger(tempByteArray);
        this.setMaximumBandwidth(Float.intBitsToFloat(maxBandwidth));
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        byte[] linkSubTypeBody = IsisUtil.convertToFourBytes(Float.floatToIntBits(this.maximumReservableBandwidth));
        return linkSubTypeBody;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("maximumReservableBandwidth", this.maximumReservableBandwidth).toString();
    }
}

