/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.NeighborIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceIpAddress
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private static final Logger log = LoggerFactory.getLogger(NeighborIpAddress.class);
    private Ip4Address localInterfaceIPAddress;

    public InterfaceIpAddress(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public void setIpAddress(Ip4Address localAddress) {
        this.localInterfaceIPAddress = localAddress;
    }

    public Ip4Address localInterfaceIPAddress() {
        return this.localInterfaceIPAddress;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 4) {
            byte[] tempByteArray = new byte[4];
            channelBuffer.readBytes(tempByteArray, 0, 4);
            this.setIpAddress(Ip4Address.valueOf((byte[])tempByteArray));
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        ArrayList linkSubTypeBody = new ArrayList();
        linkSubTypeBody.addAll(Bytes.asList((byte[])this.localInterfaceIPAddress.toOctets()));
        return Bytes.toArray(linkSubTypeBody);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("localInterfaceIPAddress", (Object)this.localInterfaceIPAddress).toString();
    }
}

