/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum TlvType {
    AREAADDRESS(1),
    ISREACHABILITY(2),
    ISNEIGHBORS(6),
    PADDING(8),
    LSPENTRY(9),
    AUTHENTICATION(10),
    HOSTNAME(137),
    EXTENDEDISREACHABILITY(22),
    ISALIAS(24),
    IPINTERNALREACHABILITY(128),
    PROTOCOLSUPPORTED(129),
    IPEXTERNALREACHABILITY(130),
    IPEXTENDEDREACHABILITY(135),
    IDRPINFORMATION(131),
    IPINTERFACEADDRESS(132),
    ADJACENCYSTATE(240);

    private static final Map<Integer, TlvType> LOOKUP;
    private int value;

    private TlvType(int value) {
        this.value = value;
    }

    public static TlvType get(int tlvTypeValue) {
        return LOOKUP.get(tlvTypeValue);
    }

    public int value() {
        return this.value;
    }

    static {
        LOOKUP = new HashMap<Integer, TlvType>();
        for (TlvType isisTlvType : EnumSet.allOf(TlvType.class)) {
            LOOKUP.put(isisTlvType.value(), isisTlvType);
        }
    }
}

