/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.IdrpInformationTlv;
import org.onosproject.isis.io.isispacket.tlv.IpExtendedReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInternalReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsExtendedReachability;
import org.onosproject.isis.io.isispacket.tlv.IsReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.PaddingTlv;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;

public class TlvFinder
extends TlvHeader {
    public static IsisTlv findTlv(TlvHeader tlvHeader, ChannelBuffer channelBuffer) {
        TlvHeader isisTlv = null;
        switch (TlvType.get(tlvHeader.tlvType())) {
            case AREAADDRESS: {
                AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
                areaAddressTlv.readFrom(channelBuffer);
                isisTlv = areaAddressTlv;
                break;
            }
            case AUTHENTICATION: {
                break;
            }
            case EXTENDEDISREACHABILITY: {
                IsExtendedReachability isExtendedReachability = new IsExtendedReachability(tlvHeader);
                isExtendedReachability.readFrom(channelBuffer);
                isisTlv = isExtendedReachability;
                break;
            }
            case HOSTNAME: {
                HostNameTlv hostNameTlv = new HostNameTlv(tlvHeader);
                hostNameTlv.readFrom(channelBuffer);
                isisTlv = hostNameTlv;
                break;
            }
            case IDRPINFORMATION: {
                IdrpInformationTlv idrpInformationTlv = new IdrpInformationTlv(tlvHeader);
                idrpInformationTlv.readFrom(channelBuffer);
                isisTlv = idrpInformationTlv;
                break;
            }
            case IPEXTENDEDREACHABILITY: {
                IpExtendedReachabilityTlv iperTlv = new IpExtendedReachabilityTlv(tlvHeader);
                iperTlv.readFrom(channelBuffer);
                isisTlv = iperTlv;
                break;
            }
            case IPINTERFACEADDRESS: {
                IpInterfaceAddressTlv ipTlv = new IpInterfaceAddressTlv(tlvHeader);
                ipTlv.readFrom(channelBuffer);
                isisTlv = ipTlv;
                break;
            }
            case IPINTERNALREACHABILITY: {
                IpInternalReachabilityTlv iprTlv = new IpInternalReachabilityTlv(tlvHeader);
                iprTlv.readFrom(channelBuffer);
                isisTlv = iprTlv;
                break;
            }
            case ISALIAS: {
                break;
            }
            case PROTOCOLSUPPORTED: {
                ProtocolSupportedTlv psTlv = new ProtocolSupportedTlv(tlvHeader);
                psTlv.readFrom(channelBuffer);
                isisTlv = psTlv;
                break;
            }
            case ISREACHABILITY: {
                IsReachabilityTlv isrTlv = new IsReachabilityTlv(tlvHeader);
                isrTlv.readFrom(channelBuffer);
                isisTlv = isrTlv;
                break;
            }
            case ISNEIGHBORS: {
                IsisNeighborTlv isisNeighborTlv = new IsisNeighborTlv(tlvHeader);
                isisNeighborTlv.readFrom(channelBuffer);
                isisTlv = isisNeighborTlv;
                break;
            }
            case LSPENTRY: {
                LspEntriesTlv lspEntriesTlv = new LspEntriesTlv(tlvHeader);
                lspEntriesTlv.readFrom(channelBuffer);
                isisTlv = lspEntriesTlv;
                break;
            }
            case PADDING: {
                PaddingTlv paddingTlv = new PaddingTlv(tlvHeader);
                paddingTlv.readFrom(channelBuffer);
                isisTlv = paddingTlv;
                break;
            }
            case ADJACENCYSTATE: {
                AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
                adjacencyStateTlv.readFrom(channelBuffer);
                isisTlv = adjacencyStateTlv;
                break;
            }
        }
        return isisTlv;
    }
}

