/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class ProtocolSupportedTlv
extends TlvHeader
implements IsisTlv {
    private List<Byte> protocolSupported = new ArrayList<Byte>();

    public ProtocolSupportedTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public void addProtocolSupported(byte protocolValue) {
        this.protocolSupported.add(protocolValue);
    }

    public List<Byte> protocolSupported() {
        return this.protocolSupported;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() > 0) {
            this.protocolSupported.add(channelBuffer.readByte());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (byte byt : this.protocolSupported) {
            bytes.add(byt);
        }
        byte[] byteArray = new byte[bytes.size()];
        int i = 0;
        Iterator iterator = bytes.iterator();
        while (iterator.hasNext()) {
            byte byt = (Byte)iterator.next();
            byteArray[i++] = byt;
        }
        return byteArray;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("protocolSupported", this.protocolSupported).toString();
    }
}

